/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui.render;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.render.Renderer;

public abstract class AbstractEnumRenderer<E extends Enum<E>>
implements Renderer<E> {
    protected HashMap<E, String> initMessageMap(Class<E> enumClass) {
        HashMap<Enum, String> messageMap = new HashMap<Enum, String>();
        Class<?> rendererClass = this.getClass();
        ClassLoader classLoader = rendererClass.getClassLoader();
        MessageCatalog catalog = new MessageCatalog(classLoader);
        try {
            Enum[] values;
            catalog.loadCatalog(rendererClass.getName());
            for (Enum value : values = (Enum[])enumClass.getEnumConstants()) {
                String message = catalog.translate(value.toString()).trim();
                messageMap.put(value, message);
            }
        }
        catch (MissingResourceException exc) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, exc.getMessage(), exc);
        }
        return messageMap;
    }
}

