/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.homelinux.elabor.tools.InvalidPathException;
import org.homelinux.elabor.ui.EnterShortcutListener;
import org.homelinux.elabor.ui.panel.DefaultPanel;

public class UITools {
    private UITools() {
    }

    public static void addComponent(Container container, Component component, int x, int y, int w, int h, int wx, int wy, int fill, int inset) {
        UITools.addComponent(container, component, x, y, w, h, wx, wy, fill, inset, 10);
    }

    public static void addComponent(Container container, Component component, int x, int y, int w, int h, int wx, int wy, int fill, int inset, int anchor) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.fill = fill;
        gbc.insets = new Insets(inset, inset, inset, inset);
        gbc.anchor = anchor;
        container.add(component, gbc);
    }

    public static ImageIcon createImageIcon(ClassLoader loader, String path) throws InvalidPathException {
        URL imgURL = loader.getResource(path);
        if (imgURL == null) {
            throw new InvalidPathException(path);
        }
        return new ImageIcon(imgURL);
    }

    public static void setupField(JTextComponent field, float fontSize, Color gbColor) {
        field.setFont(field.getFont().deriveFont(fontSize));
        field.setBackground(gbColor);
        field.setEditable(true);
    }

    public static JTextField setupTextField(float fontSize, Color bgColor) {
        JTextField field = new JTextField();
        UITools.setupField(field, fontSize, bgColor);
        return field;
    }

    public static JTextField setupTextField(DefaultPanel<?> panel, float fontSize, Color bgColor) {
        JTextField field = UITools.setupTextField(fontSize, bgColor);
        field.addKeyListener(new EnterShortcutListener(panel));
        return field;
    }

    public static JLabel setupLabel(String labelText, float fontSize) {
        JLabel label = new JLabel();
        label.setFont(label.getFont().deriveFont(fontSize));
        label.setOpaque(true);
        label.setText(labelText);
        return label;
    }

    public static JScrollPane setupTextArea(JTextArea field, float fontSize, Color bgColor) {
        UITools.setupField(field, fontSize, bgColor);
        field.setLineWrap(true);
        field.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(field);
        scrollPane.setBorder(new LineBorder(Color.BLACK));
        return scrollPane;
    }

    public static JButton setupButton(String label, String tooltip, ActionListener listener) {
        return UITools.setupButton(label, tooltip, listener, false);
    }

    public static JButton setupButton(String label, String tooltip, ActionListener listener, boolean enabled) {
        JButton button = new JButton(label);
        button.setToolTipText(tooltip);
        if (listener != null) {
            button.addActionListener(listener);
        }
        button.setEnabled(enabled);
        return button;
    }

    public static JButton createButton(URL iconUrl, URL selectedIconUrl, String toolTipLabel, ActionListener listener) {
        ImageIcon icon = new ImageIcon(iconUrl);
        JButton button = new JButton(icon);
        if (selectedIconUrl != null) {
            ImageIcon selectedIcon = new ImageIcon(selectedIconUrl);
            button.setSelectedIcon(selectedIcon);
        }
        button.setOpaque(false);
        button.addActionListener(listener);
        button.setToolTipText(toolTipLabel);
        return button;
    }
}

