/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageCatalog {
    private ResourceBundle bundle;
    private ClassLoader classLoader;
    private String resource;

    public MessageCatalog() {
        this.classLoader = this.getClass().getClassLoader();
    }

    public MessageCatalog(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void loadCatalog(String resourceName) {
        this.loadCatalog(resourceName, Locale.getDefault());
    }

    public void loadCatalog(String resourceName, String language) {
        this.loadCatalog(resourceName, new Locale(language));
    }

    public void loadCatalog(String resourceName, Locale locale) {
        this.bundle = ResourceBundle.getBundle(resourceName, locale, this.classLoader);
        this.resource = resourceName;
    }

    public String translate(String label) {
        String value = label;
        if (this.bundle != null) {
            try {
                value = this.getString(label);
            }
            catch (MissingResourceException exc) {
                String message = this.resource + ": " + exc.toString();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, message);
            }
        }
        return value;
    }

    public String getString(String label) {
        return this.bundle.getString(label);
    }
}

