/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.services;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.TransformerException;
import org.homelinux.elabor.file.ExtensionFileFilter;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionStreamer;
import org.homelinux.elabor.scriptorium.ecomponents.EditionValidator;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSet;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.TextPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.operations.ExportDirectorFactory;
import org.homelinux.elabor.scriptorium.services.EditionProcessor;
import org.homelinux.elabor.scriptorium.utils.Version;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class EditionManager {
    private static final String SCRIPTORIUM_HTML_STYLESHEET = "scriptorium-html.xst";
    private static final String SCRIPTORIUM_TXT_STYLESHEET = "scriptorium-txt.xst";
    private static final String SCRIPTORIUM_LATEX_STYLESHEET = "scriptorium-latex.xst";
    private static final String XML_EXTENSION = ".xml";
    private static final String TEX_EXTENSION = ".tex";
    private static final String OWL_EXTENSION = ".owl";
    private static final String TXT_EXTENSION = ".txt";
    private static final String[] IMAGES_EXTENSIONS = new String[]{".jpg", ".jpeg", ".png", ".gif"};
    private static final String DRAFT_DEFAULT_PATH = "draft_files";
    private static final String STYLE_DEFAULT_PATH = "style_files";
    private static final String IMAGE_DEFAULT_PATH = "image_files";
    private static EditionManager instance;
    private String styleErrorString;
    private String transformerErrorString;
    private String xmlFilesString;
    private String texFilesString;
    private String owlFilesString;
    private String imagesFilesString;
    private String txtDescriptionString;
    private String fileString;
    private String alreadyExistsString;
    private String validationNotEnabledString;
    private String overwriteString;
    private String chooseString;
    private String editionsTitleString;
    private String editionsLabelString;
    private String editionsTooltipString;
    private String confirmFolderString;
    private String operationCompleteString;
    private String unknownString;
    private EditionStreamer streamer;
    private EditionValidator validator;
    private File editionCurrentFolder;
    private File stylesetCurrentFolder;
    private File imageCurrentFolder;
    private ExtensionFileFilter xmlFilter;
    private ExtensionFileFilter texFilter;
    private ExtensionFileFilter owlFilter;
    private FileFilter imagesFilter;
    private String namesOntology;

    public static synchronized EditionManager getInstance() {
        if (instance == null) {
            instance = new EditionManager();
        }
        return instance;
    }

    private EditionManager() {
        this.initLocale();
        Version version = Version.getInstance();
        String releaseNumber = version.getReleaseNumber();
        this.streamer = new EditionStreamer(releaseNumber);
        Preferences preferences = Preferences.getInstance();
        File editionDefaultFolder = preferences.getFile(DRAFT_DEFAULT_PATH);
        File stylesetPrefFolder = preferences.getFile(STYLE_DEFAULT_PATH);
        File imagePrefFolder = preferences.getFile(IMAGE_DEFAULT_PATH);
        this.editionCurrentFolder = editionDefaultFolder;
        this.stylesetCurrentFolder = EditionManager.getDefaultFolder(this.editionCurrentFolder, stylesetPrefFolder);
        this.imageCurrentFolder = EditionManager.getDefaultFolder(this.editionCurrentFolder, imagePrefFolder);
        this.namesOntology = preferences.getString("names_ontology");
        boolean validate = preferences.getBoolean("validate");
        if (validate) {
            this.validator = EditionValidator.getInstance();
        } else {
            this.validator = null;
            JOptionPane.showMessageDialog(null, this.validationNotEnabledString, UIConstants.getInstance().attentionString, 2);
        }
        this.xmlFilter = new ExtensionFileFilter(XML_EXTENSION, this.xmlFilesString);
        this.imagesFilter = new ExtensionFileFilter(IMAGES_EXTENSIONS, this.imagesFilesString);
        this.texFilter = new ExtensionFileFilter(TEX_EXTENSION, this.texFilesString);
        this.owlFilter = new ExtensionFileFilter(OWL_EXTENSION, this.owlFilesString);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        Class<?> classObj = this.getClass();
        String className = classObj.getName();
        catalog.loadCatalog(className, locale);
        this.styleErrorString = catalog.translate("styleError");
        this.transformerErrorString = catalog.translate("transformerError");
        this.xmlFilesString = catalog.translate("xmlFiles");
        this.texFilesString = catalog.translate("texFiles");
        this.owlFilesString = catalog.translate("owlFiles");
        this.imagesFilesString = catalog.translate("imageFiles");
        this.txtDescriptionString = catalog.translate("txtDescription");
        this.fileString = catalog.translate("file");
        this.alreadyExistsString = catalog.translate("alreadyExists");
        this.overwriteString = catalog.translate("overwrite");
        this.validationNotEnabledString = catalog.translate("validationNotEnabled");
        this.chooseString = catalog.translate("choose");
        this.editionsTitleString = catalog.translate("editionsTitle");
        this.editionsLabelString = catalog.translate("editionsLabel");
        this.editionsTooltipString = catalog.translate("editionsTooltip");
        this.confirmFolderString = catalog.translate("confirmFolder");
        this.operationCompleteString = catalog.translate("operationComplete");
        this.unknownString = catalog.translate("unknown");
    }

    public Edition loadEdition(File editionFile) {
        return this.loadEdition(editionFile, true);
    }

    public Edition loadEdition(File file, boolean validation) {
        File editionFile = null;
        editionFile = file == null ? EditionManager.chooseLoadFile(this.editionCurrentFolder, this.xmlFilter) : file;
        Edition edition = null;
        if (editionFile != null) {
            this.editionCurrentFolder = editionFile.getParentFile();
            Preferences preferences = Preferences.getInstance();
            preferences.reload(this.editionCurrentFolder);
            try {
                Edition newEdition = this.streamer.load(editionFile);
                newEdition.setFile(editionFile);
                if (validation && this.validator != null) {
                    this.validator.validate(newEdition);
                }
                edition = newEdition;
            }
            catch (Exception e) {
                UIConstants uiConstants = UIConstants.getInstance();
                String message = String.valueOf(uiConstants.errorOccurredString) + e.getMessage();
                JOptionPane.showMessageDialog(null, message, uiConstants.errorString, 0);
            }
        }
        return edition;
    }

    public boolean saveEdition(Edition edition, boolean withName, String suggestedFileName, ExportDirectorFactory exportDirectorFactory) {
        edition.normalize();
        File file = edition.getFile();
        if (file == null || withName) {
            file = this.chooseSaveFile(this.editionCurrentFolder, file, suggestedFileName, this.xmlFilter, XML_EXTENSION);
        }
        boolean ok = false;
        if (file != null) {
            UIConstants uiConstants = UIConstants.getInstance();
            try {
                this.editionCurrentFolder = file.getParentFile();
                edition.setFile(file);
                this.streamer.save(edition);
                ok = true;
                this.streamer.exportSvg(edition, exportDirectorFactory);
            }
            catch (FileNotFoundException exc) {
                EditionManager.fileNotFoundMessage(uiConstants, exc);
            }
            catch (TransformerException exc) {
                this.transformerExceptionMessage(uiConstants, exc);
            }
        }
        return ok;
    }

    public StyleSet loadStyleset(StyleSetReference stylesetReference) {
        Edition edition = stylesetReference.getEdition();
        File stylesetDefaultFolder = EditionManager.getStylesetDefaultFolder(edition);
        File file = stylesetReference.getFile(stylesetDefaultFolder);
        if (file != null) {
            this.stylesetCurrentFolder = file.getParentFile();
        }
        return this.streamer.loadStyleset(file);
    }

    public StyleSet loadStyleset() {
        StyleSet styleset = null;
        File file = EditionManager.chooseLoadFile(this.stylesetCurrentFolder, this.xmlFilter);
        if (file != null) {
            this.stylesetCurrentFolder = file.getParentFile();
            styleset = this.streamer.loadStyleset(file);
            styleset.setFile(file);
        }
        return styleset;
    }

    public boolean saveStyleset(StyleSet styleset, boolean withName, String suggestedFileName) {
        File oldFile = styleset.getFile();
        File file = oldFile == null || withName ? this.chooseSaveFile(this.stylesetCurrentFolder, oldFile, suggestedFileName, this.xmlFilter, XML_EXTENSION) : oldFile;
        boolean ok = false;
        if (file != null) {
            styleset.setFile(file);
            UIConstants uiConstants = UIConstants.getInstance();
            try {
                Document document = styleset.getDocument();
                EditionStreamer.save(document, file);
                ok = true;
            }
            catch (FileNotFoundException exc) {
                EditionManager.fileNotFoundMessage(uiConstants, exc);
            }
            catch (TransformerException exc) {
                this.transformerExceptionMessage(uiConstants, exc);
            }
        }
        return ok;
    }

    public File chooseImageFile() {
        File file = EditionManager.chooseLoadFile(this.imageCurrentFolder, this.imagesFilter);
        if (file != null) {
            this.imageCurrentFolder = file.getParentFile();
        }
        return file;
    }

    public File chooseTexExportFile() {
        return this.chooseExportFile(this.texFilter, TEX_EXTENSION);
    }

    public File chooseOwlExportFile() {
        return this.chooseExportFile(this.owlFilter, OWL_EXTENSION);
    }

    public File chooseExportFile(ExtensionFileFilter filter, String defaultExtension) {
        return this.chooseSaveFile(this.editionCurrentFolder, null, null, filter, defaultExtension);
    }

    public void importBasicText(ScriptoriumDirector director) {
        TextPanel panel = director.getTextPanel();
        ExtensionFileFilter filter = new ExtensionFileFilter(TXT_EXTENSION, this.txtDescriptionString);
        File file = EditionManager.chooseLoadFile(this.editionCurrentFolder, filter);
        if (file != null) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedReader bR = EditionManager.newBufferedReader(file);){
                    String line;
                    StringWriter sW = new StringWriter();
                    while ((line = bR.readLine()) != null) {
                        sW.write(String.valueOf(line) + "\n");
                    }
                    panel.uploadBasicText(sW.toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exc) {
                UIConstants uiConstants = UIConstants.getInstance();
                JOptionPane.showMessageDialog(null, String.valueOf(uiConstants.ioErrorString) + ": " + exc.getLocalizedMessage(), uiConstants.errorString, 0);
            }
        }
    }

    private static BufferedReader newBufferedReader(File file) throws FileNotFoundException {
        FileReader fR = new FileReader(file);
        BufferedReader bR = new BufferedReader(fR);
        return bR;
    }

    public void export(Edition edition, String stylesheetName, String extension) {
        File doc_file = edition.getFile();
        UIConstants uiConstants = UIConstants.getInstance();
        if (doc_file == null) {
            JOptionPane.showMessageDialog(null, this.chooseString, uiConstants.errorString, 0);
        } else {
            try {
                URL style = this.getClass().getClassLoader().getResource(stylesheetName);
                EditionStreamer.export(edition, style, extension);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(null, String.valueOf(this.styleErrorString) + extension + ": " + exc.getLocalizedMessage(), uiConstants.errorString, 0);
            }
            catch (TransformerException exc) {
                this.transformerExceptionMessage(uiConstants, exc);
            }
        }
    }

    public void exportHTML(Edition edition) {
        this.export(edition, SCRIPTORIUM_HTML_STYLESHEET, ".html");
    }

    public void exportTXT(Edition edition) {
        this.export(edition, SCRIPTORIUM_TXT_STYLESHEET, TXT_EXTENSION);
    }

    public void exportLatex(Edition edition) {
        this.export(edition, SCRIPTORIUM_LATEX_STYLESHEET, TEX_EXTENSION);
    }

    public URL getIconUrl(String iconName) {
        return this.getClass().getClassLoader().getResource("icons/" + iconName + ".png");
    }

    private void transformerExceptionMessage(UIConstants uiConstants, TransformerException exc) {
        JOptionPane.showMessageDialog(null, String.valueOf(this.transformerErrorString) + ": " + exc.getLocalizedMessage(), uiConstants.errorString, 0);
    }

    private static void fileNotFoundMessage(UIConstants uiConstants, FileNotFoundException exc) {
        JOptionPane.showMessageDialog(null, String.valueOf(uiConstants.fileNotFoundString) + ": " + exc.getLocalizedMessage(), uiConstants.errorString, 0);
    }

    private static File chooseLoadFile(File folder, FileFilter filter) {
        JFileChooser fileChooser = new JFileChooser(folder);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showOpenDialog(null);
        File file = option == 0 ? fileChooser.getSelectedFile() : null;
        return file;
    }

    private File chooseSaveFile(File folder, File oldFile, String suggestedName, ExtensionFileFilter filter, String defaultExtension) {
        int option;
        File file = null;
        JFileChooser fileChooser = new JFileChooser(folder);
        fileChooser.setFileFilter(filter);
        if (oldFile == null) {
            if (suggestedName != null) {
                File suggestedFile = new File(folder, suggestedName);
                fileChooser.setSelectedFile(suggestedFile);
            }
        } else {
            fileChooser.setSelectedFile(oldFile);
        }
        if ((option = fileChooser.showSaveDialog(null)) == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            selectedFile = EditionManager.forceExtension(selectedFile, null, defaultExtension);
            String fileName = selectedFile.getName();
            if (selectedFile.exists()) {
                UIConstants uiConstants = UIConstants.getInstance();
                int confirmOption = JOptionPane.showConfirmDialog(null, String.valueOf(this.fileString) + " '" + fileName + "' " + this.alreadyExistsString + ". " + uiConstants.confirmString + " " + this.overwriteString, uiConstants.attentionString, 0);
                if (confirmOption == 0) {
                    file = selectedFile;
                }
            } else {
                file = selectedFile;
            }
        }
        return file;
    }

    private static File forceExtension(File file, String dropExtension, String defaultExtension) {
        File value;
        String filePath = file.getAbsolutePath();
        if (filePath.endsWith(defaultExtension)) {
            value = file;
        } else {
            if (dropExtension != null && filePath.endsWith(dropExtension)) {
                int length = filePath.length() - dropExtension.length();
                filePath = filePath.substring(0, length);
            }
            value = new File(String.valueOf(filePath) + defaultExtension);
        }
        return value;
    }

    public File[] chooseEditionFiles() {
        JFileChooser chooser = new JFileChooser(this.editionCurrentFolder);
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(this.xmlFilter);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(this.editionsTitleString);
        chooser.setApproveButtonText(this.editionsLabelString);
        chooser.setApproveButtonToolTipText(this.editionsTooltipString);
        int result = chooser.showOpenDialog(null);
        File[] selectedFiles = result == 0 ? chooser.getSelectedFiles() : new File[]{};
        return selectedFiles;
    }

    public boolean checkFolder(File[] files) {
        boolean ok = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ok = ok && !file.isDirectory();
            ++n2;
        }
        if (!ok) {
            int option = JOptionPane.showConfirmDialog(null, this.confirmFolderString, null, 0);
            ok = option == 0;
        }
        return ok;
    }

    public void processFiles(File[] files, EditionProcessor processor, boolean confirmFolders) {
        boolean ok = true;
        if (confirmFolders) {
            ok = this.checkFolder(files);
        }
        if (ok) {
            try {
                this.processFiles(files, processor);
                JOptionPane.showMessageDialog(null, this.operationCompleteString);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                JOptionPane.showMessageDialog(null, exc.getMessage());
            }
        }
    }

    private void processFiles(File[] files, EditionProcessor processor) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (this.xmlFilter.accept(file)) {
                    this.processFile(file, processor);
                }
            } else {
                File[] folderFiles = file.listFiles();
                this.processFiles(folderFiles, processor);
            }
            ++n2;
        }
    }

    private void processFile(File file, EditionProcessor processor) {
        try {
            Edition edition = this.streamer.load(file);
            this.validator.validate(edition);
            processor.processEdition(edition, this.streamer);
        }
        catch (SAXException exc) {
            JOptionPane.showMessageDialog(null, String.valueOf(file.getName()) + " is not a valid Scriptorium file");
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(null, "error while loading: " + file.getName());
        }
    }

    public Ontology getArchivesOntology() {
        return this.getOntology("archives.owl");
    }

    public Ontology getEditionsOntology() {
        return this.getOntology("editions.owl");
    }

    public Ontology getPublicationsOntology() {
        return this.getOntology("publications.owl");
    }

    public Ontology getTonguesOntology() {
        return this.getOntology("tongues.owl");
    }

    public Ontology getKeywordsOntology() {
        return this.getOntology("keywords.owl");
    }

    public Ontology getMathConceptsOntology() {
        return this.getOntology("math_concepts.owl");
    }

    public Ontology getNamesOntology() {
        return this.getOntology(this.namesOntology);
    }

    public Ontology getPlacesOntology() {
        return this.getOntology("places.owl");
    }

    public Ontology getVariantsOntology() {
        return this.getOntology("variants.owl");
    }

    public Ontology getWorksOntology() {
        return this.getOntology("works.owl");
    }

    public Ontology getTextPartsOntology() {
        return this.getOntology("text-parts.owl");
    }

    private Ontology getOntology(String filename) {
        URL ontologyUrl = this.getClass().getClassLoader().getResource(filename);
        return new Ontology(ontologyUrl);
    }

    public File getImageFile(URI uri, Edition edition) {
        File imageDefaultFolder = EditionManager.getImageDefaultFolder(edition);
        return EditionManager.getFile(uri, this.editionCurrentFolder, imageDefaultFolder);
    }

    private static File getFile(URI uri, File currentFolder, File defaultFolder) {
        File defaultFile;
        File file = EditionManager.getFile(currentFolder, uri);
        if (!file.exists() && (defaultFile = EditionManager.getFile(defaultFolder, uri)).exists()) {
            file = defaultFile;
        }
        return file;
    }

    private static File getFile(File folder, URI uri) {
        URI currURI = folder.toURI();
        URI fileURI = currURI.resolve(uri);
        return new File(fileURI);
    }

    public static File forceTexExtension(File file) {
        return EditionManager.forceExtension(file, XML_EXTENSION, TEX_EXTENSION);
    }

    public static File forceOwlExtension(File file) {
        return EditionManager.forceExtension(file, XML_EXTENSION, OWL_EXTENSION);
    }

    public static File getImageDefaultFolder(Edition edition) {
        Preferences preferences = Preferences.getInstance();
        File imagePrefFolder = preferences.getFile(IMAGE_DEFAULT_PATH);
        return EditionManager.getDefaultFolder(edition, imagePrefFolder);
    }

    public static File getStylesetDefaultFolder(Edition edition) {
        Preferences preferences = Preferences.getInstance();
        File stylesetPrefFolder = preferences.getFile(STYLE_DEFAULT_PATH);
        return EditionManager.getDefaultFolder(edition, stylesetPrefFolder);
    }

    private static File getDefaultFolder(Edition edition, File folder) {
        File editionFile = edition.getFile();
        File editionFolder = editionFile == null ? new File("") : editionFile.getParentFile();
        return EditionManager.getDefaultFolder(editionFolder, folder);
    }

    private static File getDefaultFolder(File editionFolder, File folder) {
        File value = folder.isAbsolute() ? folder : new File(editionFolder, folder.getPath());
        return value;
    }

    public String getOntologyValue(Ontology ontology, OntologyReferenceInterface reference) {
        OntologyClass ontologyClass = ontology.getOntologyClass(reference);
        String ontologyValue = ontologyClass == null ? this.unknownString : ontologyClass.toString();
        return ontologyValue;
    }

    public static String getOntologyOrder(Ontology ontology, OntologyReferenceInterface reference) {
        OntologyClass ontologyClass = ontology.getOntologyClass(reference);
        String ontologyValue = ontologyClass == null ? "ZZZZZZZZZ" : ontologyClass.getOrderString();
        return ontologyValue;
    }

    public static void operationCancelled() {
        UIConstants uiConstants = UIConstants.getInstance();
        JOptionPane.showMessageDialog(null, uiConstants.operationCancelledString, "error", 0);
    }
}

