/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractStraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public final class StraightLineAction
extends AbstractStraightLineAction<StraightLineAction> {
    public StraightLineAction() {
    }

    public StraightLineAction(Element element) {
        super(element);
    }

    @Override
    public String getElementName() {
        return "straight_line";
    }

    @Override
    protected StraightLineAction make(Element element) {
        return new StraightLineAction(element);
    }

    @Override
    protected DraftVector getVector(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        double dy;
        double dx;
        List<ScriptoriumPoint> points = this.getFixedPoints(drawingPoints);
        Array2DRowRealMatrix A = new Array2DRowRealMatrix(2, 2);
        ArrayRealVector B = new ArrayRealVector(2);
        double sx2 = 0.0;
        double sy2 = 0.0;
        double sxy = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        for (ScriptoriumPoint point : points) {
            double x = point.getX();
            double y = point.getY();
            sx2 += x * x;
            sxy += x * y;
            sy2 += y * y;
            sx += x;
            sy += y;
        }
        A.setEntry(0, 0, sx2);
        A.setEntry(0, 1, sxy);
        B.setEntry(0, -sx);
        A.setEntry(1, 0, sxy);
        A.setEntry(1, 1, sy2);
        B.setEntry(1, -sy);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)A).getSolver();
        RealVector X = solver.solve((RealVector)B);
        double a = X.getEntry(0);
        double b = X.getEntry(1);
        double x = 0.0;
        double y = -1.0 / b;
        if (Math.abs(b) < 1.0E-8) {
            dx = 0.0;
            dy = 1.0;
        } else {
            dx = 1.0;
            dy = -a / b;
        }
        return new DraftVector(x, y, dx, dy);
    }

    @Override
    public String toString() {
        return "Straight line" + this.getFixedPointsAttribute();
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }
}

