/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Equation;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.DefinizioneConiugata;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.HyperbolaDefinition;

public class HyperbolaEquation {
    private static final int N_POINTS = 5;
    private final HyperbolaDefinition hyperbolaDefinition;
    private final Point2D vertex;
    private final Point2D middle;
    private final Point2D passingBy;
    private final Point2D vertex1;
    private final Point2D vertex2;
    private final Equation equation;
    private final double minSemiAxis;
    private final double maxSemiAxis;
    private Point2D center;

    public HyperbolaEquation(HyperbolaDefinition hyperbolaDefinition, Iterable<ScriptoriumPoint> drawingPoints) {
        this.hyperbolaDefinition = hyperbolaDefinition;
        this.vertex1 = hyperbolaDefinition.getVertex12D(drawingPoints);
        this.passingBy = hyperbolaDefinition.getPassingBy2D(drawingPoints);
        this.center = hyperbolaDefinition.getCenter2D(drawingPoints);
        if (hyperbolaDefinition.hasFixedPoints()) {
            this.vertex2 = hyperbolaDefinition.getVertex22D(drawingPoints);
        } else if (this.center == null) {
            this.vertex2 = hyperbolaDefinition.getVertex22D(drawingPoints);
            this.center = GeometricHelper.middlePoint(this.vertex1, this.vertex2);
        } else {
            this.vertex2 = GeometricHelper.symmetric(this.vertex1, this.center);
        }
        DraftVector axis = new DraftVector(this.vertex1, this.center);
        Point2D axisSymm = GeometricHelper.symmetric(this.passingBy, axis);
        Point2D centerSymm = GeometricHelper.symmetric(this.passingBy, this.center);
        this.middle = GeometricHelper.middlePoint(this.passingBy, axisSymm);
        this.vertex = this.middle.distance(this.vertex1) < this.middle.distance(this.vertex2) ? this.vertex1 : this.vertex2;
        this.maxSemiAxis = this.center.distance(this.vertex);
        this.minSemiAxis = this.getHyperbolaMinSemiAxis();
        Point2D[] points = new Point2D[]{this.vertex1, this.vertex2, this.passingBy, centerSymm, axisSymm};
        this.equation = GeometricHelper.computeApproxEquation(points);
    }

    public Shape getShape(Iterable<ScriptoriumPoint> drawingPoints, boolean asymptotes) {
        Path2D.Double shape = new Path2D.Double();
        this.addShapePoints(shape, drawingPoints, asymptotes);
        if (this.hyperbolaDefinition.getNumBranches() == 4) {
            HyperbolaEquation coniugata = this.coniugata(drawingPoints);
            coniugata.addShapePoints(shape, drawingPoints, asymptotes);
        }
        return shape;
    }

    private HyperbolaEquation coniugata(Iterable<ScriptoriumPoint> drawingPoints) {
        DefinizioneConiugata coniugata = new DefinizioneConiugata(this.hyperbolaDefinition, this.maxSemiAxis, this.minSemiAxis);
        return new HyperbolaEquation(coniugata, drawingPoints);
    }

    private void addShapePoints(Path2D shape, Iterable<ScriptoriumPoint> drawingPoints, boolean asymptotes) {
        Point2D startPoint2D = this.hyperbolaDefinition.getStart2D(drawingPoints);
        Point2D endPoint2D = this.hyperbolaDefinition.getEnd2D(drawingPoints);
        Point2D start = this.nearestPoint(startPoint2D);
        Point2D end = this.nearestPoint(endPoint2D);
        double step = this.middle.distance(this.vertex) / 5.0;
        this.buildRamo(this.vertex, step, 1, start, end, asymptotes, shape);
        this.buildRamo(this.vertex, step, -1, start, end, asymptotes, shape);
        if (this.hyperbolaDefinition.getNumBranches() > 1) {
            Point2D branchVertex = this.vertex.equals(this.vertex1) ? this.vertex2 : this.vertex1;
            this.buildRamo(branchVertex, step, 1, start, end, asymptotes, shape);
            this.buildRamo(branchVertex, step, -1, start, end, asymptotes, shape);
        }
    }

    private double getHyperbolaMinSemiAxis() {
        double distance = this.center.distance(this.middle);
        double elong = this.middle.distance(this.passingBy);
        double arc = GeometricHelper.arcosh(distance / this.maxSemiAxis);
        return elong / Math.sinh(arc);
    }

    private Point2D nearestPoint(Point2D point) {
        Point2D near1 = this.nearestPoint(point, this.vertex1);
        Point2D near2 = this.nearestPoint(point, this.vertex2);
        return point.distance(near1) < point.distance(near2) ? near1 : near2;
    }

    private Point2D nearestPoint(Point2D point, Point2D branchVertex) {
        Point2D candidate2;
        Point2D candidate1;
        DraftVector axis = new DraftVector(this.center, branchVertex);
        DraftVector vertexVector = new DraftVector(point, branchVertex);
        Point2D nearest = point;
        do {
            Point2D axisPoint = GeometricHelper.nearestPoint(axis, nearest);
            double elong = axisPoint.distance(nearest);
            Point2D secondConicPoint = this.getHyperbolaPointByElong(axis, elong, 1);
            Point2D second = HyperbolaEquation.findNext(nearest, secondConicPoint, axis);
            DraftVector tangent = this.equation.tangent(second);
            candidate1 = GeometricHelper.nearestPoint(tangent, point);
            try {
                candidate2 = GeometricHelper.intersection(vertexVector, tangent);
            }
            catch (InvalidValueException exc) {
                throw new RuntimeException(exc);
            }
        } while (Math.abs(this.equation.value(nearest = Math.abs(this.equation.value(candidate1)) > Math.abs(this.equation.value(candidate2)) ? candidate2 : candidate1)) > 1000.0);
        return nearest;
    }

    private static Point2D findNext(Point2D point, Point2D conicPoint, DraftVector axis) {
        Point2D symmPoint = GeometricHelper.symmetric(conicPoint, axis);
        return point.distance(conicPoint) > point.distance(symmPoint) ? symmPoint : conicPoint;
    }

    private Point2D getHyperbolaPointByElong(DraftVector axis, double elong, int verso) {
        double sinh = elong / this.minSemiAxis;
        double arch = GeometricHelper.arsinh(sinh);
        double distance = Math.cosh(arch) * this.maxSemiAxis;
        Point2D axisPoint = GeometricHelper.shift(axis, distance);
        double dx = axis.getDx();
        double dy = axis.getDy();
        return GeometricHelper.shift(axisPoint, (double)verso * dy, (double)(-verso) * dx, elong);
    }

    private void buildRamo(Point2D branchVertex, double step, int verso, Point2D start, Point2D end, boolean asymptotes, Path2D shape) {
        shape.moveTo(branchVertex.getX(), branchVertex.getY());
        DraftVector prevTan = this.equation.tangent(branchVertex);
        int index = 1;
        while (index <= 5) {
            double delta = step * (double)index;
            prevTan = this.addPoint(branchVertex, delta, prevTan, verso, shape);
            ++index;
        }
        prevTan = this.addPoint(branchVertex, start, prevTan, verso, shape);
        prevTan = this.addPoint(branchVertex, end, prevTan, verso, shape);
        if (asymptotes) {
            Point2D directionPoint = GeometricHelper.shift(this.center, this.maxSemiAxis, this.minSemiAxis * (double)verso, 1.0);
            double xc = this.center.getX();
            double dx = branchVertex.getX() - xc;
            double yc = this.center.getY();
            double dy = branchVertex.getY() - yc;
            double alpha = Math.atan2(dy, dx);
            AffineTransform transform = AffineTransform.getRotateInstance(alpha, xc, yc);
            directionPoint = transform.transform(directionPoint, null);
            DraftVector asymVector = new DraftVector(this.center, directionPoint);
            shape.moveTo(xc, yc);
            double delta = step * 5.0;
            Point2D conicPoint = HyperbolaEquation.getHyperbolaPoint(this.center, branchVertex, this.minSemiAxis, delta, verso);
            Point2D point = GeometricHelper.nearestPoint(asymVector, conicPoint);
            double maxDistance = this.center.distance(point);
            Point2D limit1 = GeometricHelper.nearestPoint(asymVector, start);
            maxDistance = Math.max(maxDistance, this.center.distance(limit1));
            Point2D limit2 = GeometricHelper.nearestPoint(asymVector, end);
            maxDistance = Math.max(maxDistance, this.center.distance(limit2));
            Point2D asymPoint = GeometricHelper.shift(asymVector, maxDistance);
            shape.lineTo(asymPoint.getX(), asymPoint.getY());
        }
    }

    private DraftVector addPoint(Point2D branchVertex, Point2D point, DraftVector prevTan, int verso, Path2D shape) {
        DraftVector tan;
        DraftVector axis = new DraftVector(this.center, branchVertex);
        Point2D last = shape.getCurrentPoint();
        Point2D symmLast = GeometricHelper.symmetric(last, axis);
        if (point.distance(last) < point.distance(symmLast)) {
            double delta = HyperbolaEquation.getDelta(branchVertex, point, axis);
            double lastDelta = HyperbolaEquation.getDelta(branchVertex, last, axis);
            tan = lastDelta < delta ? this.addPoint(branchVertex, delta, prevTan, verso, shape) : prevTan;
        } else {
            tan = prevTan;
        }
        return tan;
    }

    private static double getDelta(Point2D branchVertex, Point2D point, DraftVector axis) {
        Point2D axisPoint = GeometricHelper.nearestPoint(axis, point);
        return branchVertex.distance(axisPoint);
    }

    private DraftVector addPoint(Point2D branchVertex, double delta, DraftVector prevTan, int verso, Path2D shape) {
        Point2D conicPoint = HyperbolaEquation.getHyperbolaPoint(this.center, branchVertex, this.minSemiAxis, delta, verso);
        double x = conicPoint.getX();
        double y = conicPoint.getY();
        DraftVector tan = this.equation.tangent(conicPoint);
        if (conicPoint.distance(branchVertex) > 10.0 * this.maxSemiAxis) {
            shape.lineTo(x, y);
        } else {
            try {
                Point2D bezier = GeometricHelper.intersection(prevTan, tan);
                double bx = bezier.getX();
                double by = bezier.getY();
                shape.quadTo(bx, by, x, y);
            }
            catch (InvalidValueException exc) {
                System.out.println(exc.toString());
                shape.lineTo(x, y);
            }
        }
        return tan;
    }

    public static Point2D getHyperbolaPoint(Point2D center, Point2D branchVertex, double minSemiAxis, double delta, int verso) {
        double dx = branchVertex.getX() - center.getX();
        double dy = branchVertex.getY() - center.getY();
        double maxSemiAxis = center.distance(branchVertex);
        Point2D axisPoint = GeometricHelper.shift(branchVertex, dx, dy, delta);
        double distance = center.distance(axisPoint);
        double arc = GeometricHelper.arcosh(distance / maxSemiAxis);
        double elong = Math.sinh(arc) * minSemiAxis;
        return GeometricHelper.shift(axisPoint, dy * (double)verso, -dx * (double)verso, elong);
    }

    public void snap(ScriptoriumPoint scriptoriumPoint) {
        Point2D point = scriptoriumPoint.getPoint2D();
        Point2D hyperbolaPoint = this.nearestPoint(point);
        scriptoriumPoint.setSnap(hyperbolaPoint);
    }

    public DraftVector tangent(ScriptoriumPoint point) {
        Point2D point2D = point.getPoint2D();
        return this.equation.tangent(point2D);
    }
}

