/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjectionManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.homelinux.elabor.scriptorium.ndraft.actions.HorizontalManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.OrthogonalManager;
import org.homelinux.elabor.scriptorium.ndraft.actions.VerticalManager;

public class DraftProjection {
    public static final String ORTHOGONAL = "ORTHOGONAL";
    public static final String VERTICAL = "VERTICAL";
    public static final String HORIZONTAL = "HORIZONTAL";
    private static Map<String, DraftProjection> VALUES = new LinkedHashMap<String, DraftProjection>();
    private final DraftProjectionManager manager;

    static {
        VALUES.put(ORTHOGONAL, new DraftProjection(new OrthogonalManager()));
        VALUES.put(VERTICAL, new DraftProjection(new VerticalManager()));
        VALUES.put(HORIZONTAL, new DraftProjection(new HorizontalManager()));
    }

    public static Collection<DraftProjection> values() {
        return VALUES.values();
    }

    public static DraftProjection getValue(String key) {
        return VALUES.get(key);
    }

    private DraftProjection(DraftProjectionManager manager) {
        this.manager = manager;
    }

    public DraftProjection(ComputeAction action) {
        this(new ActionManager(action));
    }

    public void execute(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        this.manager.execute(vector, point, drawingPoints, drawingActions);
    }

    public String toString() {
        return this.manager.toString();
    }
}

