/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft.actions;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.homelinux.elabor.exceptions.InvalidValueException;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.gui.drawings.GeometricHelper;
import org.homelinux.elabor.scriptorium.ndraft.actions.AbstractAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.ActionPoint;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftProjection;
import org.homelinux.elabor.scriptorium.ndraft.actions.DraftVector;
import org.w3c.dom.Element;

public abstract class AbstractStraightLineAction<T extends EditionComponent<T>>
extends AbstractAction<T> {
    protected abstract DraftVector getVector(Iterable<ScriptoriumPoint> var1, Iterable<ComputeAction> var2) throws InvalidValueException;

    public AbstractStraightLineAction() {
    }

    public AbstractStraightLineAction(Element element) {
        super(element);
    }

    @Override
    protected void project(ScriptoriumPoint point, AbstractStraightLineAction<?> straightLineAction, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        DraftVector thisVector = this.getVector(drawingPoints, drawingActions);
        DraftVector fixingVector = straightLineAction.getVector(drawingPoints, drawingActions);
        Point2D intersection = GeometricHelper.intersection(thisVector, fixingVector);
        point.setSnap(intersection);
    }

    @Override
    protected void project(DraftVector vector, ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        DraftVector projVector;
        DraftVector thisVector = this.getVector(drawingPoints, drawingActions);
        if (vector == null) {
            Point2D point2d = point.getPoint2D();
            double dx = thisVector.getDx();
            double dy = thisVector.getDy();
            projVector = new DraftVector(point2d, dy, -dx);
        } else {
            projVector = vector;
        }
        AbstractStraightLineAction.intersect(projVector, thisVector, point);
    }

    @Override
    protected void project(Iterable<ScriptoriumPoint> points, Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        for (ScriptoriumPoint point : points) {
            this.project(null, point, drawingPoints, drawingActions);
        }
    }

    private static void intersect(DraftVector vector1, DraftVector vector2, ScriptoriumPoint point) throws InvalidValueException {
        Point2D intersection = GeometricHelper.intersection(vector1, vector2);
        point.setSnap(intersection);
    }

    @Override
    protected void execute(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) throws InvalidValueException {
        DraftVector vector = this.getVector(drawingPoints, drawingActions);
        List<Integer> fixedPoints = this.getFixedPointReferences();
        List<ActionPoint> actionPoints = this.getActionPoints();
        for (ActionPoint actionPoint : actionPoints) {
            int id = actionPoint.getId();
            Integer key = id;
            if (fixedPoints.size() <= 2 && fixedPoints.contains(key)) continue;
            DraftProjection projection = actionPoint.getProjection(drawingActions);
            ScriptoriumPoint point = ShapeAdapter.getPoint(actionPoint, drawingPoints);
            List<ComputeAction> fixing = AbstractStraightLineAction.getFixingActions(actionPoint, drawingActions, this);
            switch (fixing.size()) {
                case 0: {
                    projection.execute(vector, point, drawingPoints, drawingActions);
                    break;
                }
                case 1: {
                    ComputeAction fixingAction = fixing.get(0);
                    fixingAction.project(point, this, drawingPoints, drawingActions);
                    break;
                }
                default: {
                    throw new InvalidValueException("is fixed", id, 0);
                }
            }
        }
    }

    private static List<ComputeAction> getFixingActions(ActionPoint actionPoint, Iterable<ComputeAction> drawingActions, AbstractStraightLineAction<?> stopAction) {
        ArrayList<ComputeAction> fixingActions = new ArrayList<ComputeAction>();
        for (ComputeAction action : drawingActions) {
            AbstractAction<?> innerAction = action.getAction();
            if (innerAction.equals(stopAction)) break;
            if (!action.isFixing(actionPoint)) continue;
            fixingActions.add(action);
        }
        return fixingActions;
    }

    @Override
    public Shape computeShape(Iterable<ScriptoriumPoint> drawingPoints, Iterable<ComputeAction> drawingActions) {
        List<ActionPoint> actionPoints = this.getActionPoints();
        List<ScriptoriumPoint> points = ShapeAdapter.getReferredPoints(actionPoints, drawingPoints);
        GeneralPath line = new GeneralPath();
        Iterator<ScriptoriumPoint> iterator = points.iterator();
        if (iterator.hasNext()) {
            ScriptoriumPoint point = iterator.next();
            line.moveTo(point.getX(), point.getY());
            while (iterator.hasNext()) {
                point = iterator.next();
                line.lineTo(point.getX(), point.getY());
            }
        }
        return line;
    }

    @Override
    protected boolean isTarget() {
        return true;
    }

    @Override
    public boolean isConicBy(ScriptoriumPoint point) {
        return false;
    }

    @Override
    protected DraftVector getTangent(ScriptoriumPoint point, Iterable<ScriptoriumPoint> drawingPoints) {
        return null;
    }

    @Override
    public boolean isConic() {
        return false;
    }
}

