/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ndraft;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.undo.UndoableEdit;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ActionsArea;
import org.homelinux.elabor.scriptorium.ndraft.NDraftUndoManager;

public class HistoryMouseListener
extends MouseAdapter {
    private final ActionsArea area;
    private final JTree historyTree;
    private final NDraftUndoManager undoManager;

    public HistoryMouseListener(ActionsArea area, JTree historyTree, NDraftUndoManager undoManager) {
        this.area = area;
        this.historyTree = historyTree;
        this.undoManager = undoManager;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() > 1) {
            Vector<UndoableEdit> edits = this.undoManager.getEdits();
            UndoableEdit currentUndo = this.undoManager.editToBeUndone();
            int current = edits.indexOf(currentUndo) + 1;
            TreeSelectionModel selectionModel = this.historyTree.getSelectionModel();
            int target = edits.size() - selectionModel.getLeadSelectionRow();
            if (current != target) {
                if (target > current) {
                    UndoableEdit edit = edits.get(target - 1);
                    this.undoManager.redoTo(edit);
                } else {
                    UndoableEdit edit = edits.get(target);
                    this.undoManager.undoTo(edit);
                }
            }
            this.area.fillHistoryTree();
        }
    }
}

