/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.variants;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.scriptorium.gui.variants.DescriptionFrame;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class VariantItemPanel
extends ScriptoriumPanel<VariantItem>
implements ActionListener,
MouseListener,
ListSelectionListener {
    public static final long serialVersionUID = 1L;
    private Edition edition;
    private Variant variant;
    private DefaultGenericSelectionModel<VariantItem> variant_items;
    private int index;
    private VariantItem variant_item;
    private DescriptionFrame descriptionFrame;
    private JTextField readingField;
    private JList<Description> descriptionsList;
    private DefaultGenericSelectionModel<Description> descriptions;
    private JButton add;
    private JButton remove;
    private String reading_string;
    private String descriptions_string;
    private String add_button_string;
    private String add_tooltip_string;
    private String rem_button_string;
    private String rem_tooltip_string;

    public VariantItemPanel() {
        this.initLocale();
        this.descriptionFrame = null;
        Preferences preferences = Preferences.getInstance();
        JLabel readingLabel = new JLabel(this.reading_string, 4);
        this.readingField = new JTextField();
        this.readingField.setFont(this.readingField.getFont().deriveFont(preferences.getInteger("text_fields_font_size")));
        this.readingField.setBackground(preferences.getColor("text_fields_editable_bg_color"));
        this.descriptionsList = new JList();
        this.descriptionsList.setBackground(preferences.getColor("lists_bg_color"));
        this.descriptionsList.addMouseListener(this);
        this.descriptionsList.addListSelectionListener(this);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.descriptionsList.setCellRenderer(renderer);
        JScrollPane descriptions_scroll = new JScrollPane(this.descriptionsList);
        this.add = new JButton(this.add_button_string);
        this.add.setToolTipText(this.add_tooltip_string);
        this.add.addActionListener(this);
        this.remove = new JButton(this.rem_button_string);
        this.remove.setToolTipText(this.rem_tooltip_string);
        this.remove.addActionListener(this);
        this.remove.setEnabled(false);
        JPanel descriptions_panel = new JPanel();
        descriptions_panel.setLayout(new GridBagLayout());
        UITools.addComponent(descriptions_panel, descriptions_scroll, 0, 0, 1, 2, 100, 100, 1, 2);
        UITools.addComponent(descriptions_panel, this.add, 1, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(descriptions_panel, this.remove, 1, 1, 1, 1, 1, 1, 2, 2);
        descriptions_panel.setBorder(new TitledBorder(new LineBorder(Color.black), this.descriptions_string));
        this.setLayout(new GridBagLayout());
        UITools.addComponent(this, readingLabel, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.readingField, 1, 0, 1, 1, 100, 1, 2, 2);
        UITools.addComponent(this, descriptions_panel, 0, 1, 2, 1, 100, 100, 1, 2);
        this.setBorder(new LineBorder(Color.black));
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.reading_string = catalog.translate("reading");
        this.descriptions_string = catalog.translate("descriptions");
        this.add_button_string = catalog.translate("add");
        this.add_tooltip_string = catalog.translate("addTooltip");
        this.rem_button_string = catalog.translate("remove");
        this.rem_tooltip_string = catalog.translate("removeTooltip");
    }

    public void setup(Edition edition, Variant variant, DefaultGenericSelectionModel<VariantItem> variant_items, int index) {
        this.edition = edition;
        this.variant = variant;
        this.variant_items = variant_items;
        this.index = index;
        this.variant_item = index >= 0 ? this.variant_items.get(this.index).makeCopy(new VariantItem()) : new VariantItem(this.variant);
        Reading reading = this.variant_item.getReading();
        this.readingField.setText(reading.toString());
        Preferences preferences = Preferences.getInstance();
        if (index > 0 || index == -1) {
            this.readingField.setBackground(preferences.getColor("text_fields_editable_bg_color"));
            this.readingField.setEditable(true);
        } else {
            this.readingField.setBackground(preferences.getColor("text_fields_protected_bg_color"));
            this.readingField.setEditable(false);
        }
        this.descriptions = new DefaultGenericSelectionModel<Description>(this.variant_item.getDescriptions());
        this.descriptionsList.setModel(this.descriptions);
    }

    private void openDescriptionFrame(int descriptionIndex) {
        if (this.descriptionFrame == null) {
            this.descriptionFrame = new DescriptionFrame(700, 200);
        }
        this.descriptionFrame.setup(this.edition, this.variant_item, this.descriptions, descriptionIndex);
    }

    private void removeSelectedDescription() {
        int selectedIndex = this.descriptionsList.getSelectedIndex();
        Description description = this.descriptions.get(selectedIndex);
        this.variant_item.removeDescription(description);
        this.descriptions.removeElementAt(selectedIndex);
    }

    @Override
    public boolean closing() {
        if (this.descriptionFrame != null) {
            this.descriptionFrame.dispose();
        }
        return super.closing();
    }

    @Override
    public boolean okAction() {
        this.variant_item.setReadingValue(this.readingField.getText());
        if (this.index >= 0) {
            this.variant.replaceChild(this.variant_items.get(this.index), this.variant_item);
            this.variant_items.set(this.index, this.variant_item);
        } else {
            this.variant.addChild(this.variant_item);
            this.variant_items.append(this.variant_item);
        }
        return super.okAction();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.add) {
            this.openDescriptionFrame(-1);
        } else if (source == this.remove) {
            this.removeSelectedDescription();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int selectedIndex;
        Object source = event.getSource();
        if (event.getClickCount() == 2 && source == this.descriptionsList && (selectedIndex = this.descriptionsList.locationToIndex(event.getPoint())) >= 0) {
            this.openDescriptionFrame(selectedIndex);
        }
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int selectedIndex = this.descriptionsList.getSelectedIndex();
        this.remove.setEnabled(selectedIndex >= 0);
    }
}

