/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.units;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.itools.Tools;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumFrame;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UITools;

public class UnitPanel
extends ScriptoriumPanel<Unit> {
    private static final long serialVersionUID = 1L;
    private Unit unit;
    private JTextField labelField;
    private JTextField noteField;
    private String labelLabelString;
    private String noteLabelString;

    public UnitPanel(ScriptoriumFrame<?> frame) {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        JLabel labelLabel = new JLabel(this.labelLabelString, 4);
        JLabel noteLabel = new JLabel(this.noteLabelString, 4);
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color fieldColor = preferences.getColor("text_fields_editable_bg_color");
        this.labelField = Tools.setupTextField(this, fontSize, fieldColor, frame);
        this.noteField = Tools.setupTextField(this, fontSize, fieldColor, frame);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, labelLabel, 0, 1, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.labelField, 1, 1, 1, 1, 10, 1, 2, 2);
        UITools.addComponent(this, noteLabel, 0, 2, 1, 1, 1, 1, 0, 2);
        UITools.addComponent(this, this.noteField, 1, 2, 1, 1, 10, 1, 2, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.labelLabelString = catalog.translate("labelLabel");
        this.noteLabelString = catalog.translate("noteLabel");
    }

    @Override
    public void setup(ScriptoriumDirector director, Unit unit) {
        this.setDirector(director);
        this.unit = unit;
        String label = this.unit.getLabel();
        this.labelField.setText(label);
        String note = this.unit.getNote();
        this.noteField.setText(note);
    }

    @Override
    public boolean okAction() {
        String label = this.labelField.getText();
        this.unit.setLabel(label);
        String note = this.noteField.getText();
        this.unit.setNote(note);
        return super.okAction();
    }
}

