/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.styles;

import java.awt.BasicStroke;
import java.awt.Color;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.Style;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.styles.DefaultStroke;
import org.homelinux.elabor.ui.ColorHelper;

public class DefaultStyle
implements Style {
    private String name;
    private Color elementColor;
    private Color elementOrigColor;
    private DefaultStroke stroke;
    private int pointSize;
    private Color labelColor;
    private int labelFontSize;
    private String fontName;
    private Color fillColor;
    private Color fillOrigColor;

    public DefaultStyle() {
        Preferences preferences = Preferences.getInstance();
        this.name = "";
        this.elementColor = preferences.getColor("lines_unselected_color", false);
        this.elementOrigColor = preferences.getColor("lines_unselected_color", true);
        int width = preferences.getInteger("lines_width");
        String pattern = preferences.getString("stroke_1");
        this.stroke = new DefaultStroke(width, pattern);
        this.pointSize = preferences.getInteger("points_size");
        this.labelColor = preferences.getColor("lines_unselected_color");
        this.labelFontSize = preferences.getInteger("label_font_size");
        this.fontName = preferences.getString("font");
        this.fillColor = ColorHelper.NULL_COLOR;
        this.fillOrigColor = ColorHelper.NULL_COLOR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Color getElementColor(boolean original) {
        return original ? this.elementOrigColor : this.elementColor;
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public int getPointSize() {
        return this.pointSize;
    }

    @Override
    public Color getLabelColor() {
        return this.labelColor;
    }

    @Override
    public int getLabelFontSize() {
        return this.labelFontSize;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public Color getFillColor(boolean original) {
        return original ? this.fillOrigColor : this.fillColor;
    }
}

