/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.styles;

import java.awt.BasicStroke;

public class DefaultStroke
extends BasicStroke {
    private String pattern;

    public DefaultStroke(String pattern) {
        this(1.0f, pattern);
        this.pattern = pattern;
    }

    public DefaultStroke(float width, String pattern) {
        super(width, 1, 0, 1.0f, DefaultStroke.analysePattern(pattern), 0.0f);
        this.pattern = pattern;
    }

    private static float[] analysePattern(String pattern) {
        String[] tokens = pattern.split(":");
        float[] dash = new float[tokens.length];
        int index = 0;
        while (index < tokens.length) {
            try {
                dash[index] = Float.parseFloat(tokens[index]);
            }
            catch (NumberFormatException exc) {
                dash[index] = 1.0f;
            }
            ++index;
        }
        return dash;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object object) {
        boolean value;
        if (object instanceof DefaultStroke) {
            DefaultStroke objectStroke = (DefaultStroke)object;
            value = this.getPattern().equals(objectStroke.getPattern());
        } else {
            value = false;
        }
        return value;
    }
}

