/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.shapes;

import java.util.List;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.UpDownArea;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapeGUI;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.GenericSelectionModel;
import org.homelinux.elabor.ui.UIConstants;
import org.homelinux.elabor.ui.UITools;
import org.homelinux.elabor.ui.panel.ListArea;

public class ShapesArea
extends ListArea<ScriptoriumShape> {
    private static final long serialVersionUID = 1L;
    private DrawingDirector director;
    private GenericSelectionModel<ScriptoriumShape> shapes;
    private ShapeFrame shapeFrame;
    private UpDownArea upDownArea;
    private String severalShapesString;

    public ShapesArea(boolean showAddButton, boolean showEditButton, boolean showRemButton) {
        super(showAddButton, showEditButton, showRemButton);
        this.initLocale();
        this.upDownArea = new UpDownArea(this);
        UITools.addComponent(this, this.upDownArea, 0, 1, 1, 3, 1, 100, 3, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(ShapesArea.class.getName(), locale);
        this.severalShapesString = catalog.translate("severalShapes");
    }

    public void setup(DrawingDirector drawingDirector) {
        this.director = drawingDirector;
        this.shapes = this.director.getShapesModel();
        super.setup(this.shapes, null);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        Iterable<ScriptoriumPoint> points = this.director.getPoints();
        renderer.setDrawingPoints(points);
        this.setCellRenderer(renderer);
        List<ShapeGUI> shapeGUIs = DefaultDrawingDirector.getShapeGUIs();
        this.shapeFrame = new ShapeFrame(shapeGUIs);
        this.shapes.addSelectionListener(this.director);
        this.upDownArea.setup(this.shapes);
    }

    private void openShapeFrame(int index) {
        this.shapeFrame.setup(this.director, index);
    }

    @Override
    public void addAction() {
        this.openShapeFrame(-1);
    }

    @Override
    public void remAction(int index, ScriptoriumShape shape) {
        this.director.removeSelectedShapes();
    }

    private List<ScriptoriumShape> getSelectedShapes() {
        List<ScriptoriumShape> selectedShapes = this.director.getSelectedShapes();
        return selectedShapes;
    }

    @Override
    public void editAction(int index, ScriptoriumShape shape) {
        List<ScriptoriumShape> selectedShapes = this.getSelectedShapes();
        int size = selectedShapes.size();
        if (size == 1) {
            this.openShapeFrame(index);
        } else {
            JOptionPane.showMessageDialog(null, this.severalShapesString, UIConstants.getInstance().errorString, 0);
        }
    }

    @Override
    public boolean closing() {
        if (this.shapeFrame != null) {
            this.shapeFrame.dispose();
        }
        return super.closing();
    }

    @Override
    public void valueChanged(boolean notify) {
        this.upDownArea.valueChanged();
        super.valueChanged(notify);
    }
}

