/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.shapes;

import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Bezier;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.CircleByCenter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Ellipse;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.EllipseByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Line;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeAdapter;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByApproximation;
import org.homelinux.elabor.scriptorium.ecomponents.old.CircleByPoints;
import org.homelinux.elabor.scriptorium.ecomponents.old.Segment;
import org.homelinux.elabor.scriptorium.gui.drawings.shapes.ShapePanel;
import org.homelinux.elabor.text.Format;
import org.homelinux.elabor.tools.MessageCatalog;

public class ShapeFieldsVisitor
implements ShapeVisitor {
    private static Locale locale = Locale.getDefault();
    private static final DecimalFormat DOUBLE_FORMAT = Format.newDecimalFormat(locale, "###,###.###");
    private ShapePanel panel;
    private Iterable<ScriptoriumPoint> drawingPoints;
    private String eccentricityString;
    private String lengthString;
    private String majorString;
    private String minorString;
    private String radiusString;
    private String angleString;
    private String ratioString;

    public ShapeFieldsVisitor(ShapePanel panel, Iterable<ScriptoriumPoint> drawingPoints) {
        this.initLocale();
        this.panel = panel;
        this.drawingPoints = drawingPoints;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.eccentricityString = catalog.translate("eccentricity");
        this.lengthString = catalog.translate("length");
        this.majorString = catalog.translate("major");
        this.minorString = catalog.translate("minor");
        this.radiusString = catalog.translate("radius");
        this.angleString = catalog.translate("angle");
        this.ratioString = catalog.translate("ratio");
    }

    @Override
    public void visit(Arc arc) {
        if (arc.isComplete()) {
            List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(arc, this.drawingPoints);
            Point2D[] points2D = ShapeAdapter.getPoints2D(shapePoints);
            arc.getShape(points2D);
            double radius = arc.getRadius();
            if (radius != 0.0) {
                double cX = arc.getX();
                double cY = arc.getY();
                this.writeRadius(radius);
                this.writeCenter(cX, cY);
            }
        }
    }

    @Override
    public void visit(Bezier bezier) {
    }

    @Override
    public void visit(CircleByApproximation circleByApproximation) {
    }

    @Override
    public void visit(CircleByCenter circleByCenter) {
        if (circleByCenter.isComplete()) {
            List<ScriptoriumPoint> shapePoints = ShapeAdapter.getShapePoints(circleByCenter, this.drawingPoints);
            Point2D[] points2D = ShapeAdapter.getPoints2D(shapePoints);
            double radius = points2D[0].distance(points2D[1]);
            this.writeRadius(radius);
        }
    }

    @Override
    public void visit(CircleByPoints circleByPoints) {
    }

    @Override
    public void visit(Ellipse ellipse) {
        if (ellipse.isComplete()) {
            List<ScriptoriumPoint> scriptoriumPoints = ShapeAdapter.getShapePoints(ellipse, this.drawingPoints);
            Point2D[] points2D = ShapeAdapter.getPoints2D(scriptoriumPoints);
            Point2D f1 = points2D[0];
            Point2D f2 = points2D[1];
            Point2D p = points2D[2];
            double semiMajor = Ellipse.getSemiMajor(f1, f2, p);
            double semiInterFocus = Ellipse.getSemiInterfocus(f1, f2);
            double semiMinor = Ellipse.getSemiMinor(semiMajor, semiInterFocus);
            this.writeSemiaxeses(f1, f2, semiMajor, semiMinor);
            this.writeEccentricity(semiMajor, semiInterFocus);
        }
    }

    @Override
    public void visit(EllipseByPoints ellipseByPoints) {
        if (ellipseByPoints.isComplete()) {
            if (ellipseByPoints.isCircle()) {
                Point2D center = ellipseByPoints.getCenter();
                double cX = center.getX();
                double cY = center.getY();
                double radius = ellipseByPoints.getRadius();
                this.writeRadius(radius);
                this.writeCenter(cX, cY);
            } else {
                Point2D f1 = ellipseByPoints.getFirstFocus();
                Point2D f2 = ellipseByPoints.getSecondFocus();
                double semiMajor = ellipseByPoints.getSemiMajorAxis();
                double semiMinor = ellipseByPoints.getSemiMinorAxis();
                double semiInterFocus = f1.distance(f2) / 2.0;
                this.writeSemiaxeses(f1, f2, semiMajor, semiMinor);
                this.writeEccentricity(semiMajor, semiInterFocus);
                this.writeFocuses(f1, f2);
            }
        }
    }

    private void writeCenter(double x, double y) {
        this.panel.addComputedValue("C (" + DOUBLE_FORMAT.format(x) + "; " + DOUBLE_FORMAT.format(y) + ")");
    }

    private void writeRadius(double radius) {
        this.panel.addComputedValue(String.valueOf(this.radiusString) + " " + DOUBLE_FORMAT.format(radius));
    }

    private void writeFocuses(Point2D f1, Point2D f2) {
        this.panel.addComputedValue("F1 (" + DOUBLE_FORMAT.format(f1.getX()) + "; " + DOUBLE_FORMAT.format(f1.getY()) + ")    " + "F2 (" + DOUBLE_FORMAT.format(f2.getX()) + "; " + DOUBLE_FORMAT.format(f2.getY()) + ")");
    }

    private void writeSemiaxeses(Point2D f1, Point2D f2, double semiMajor, double semiMinor) {
        double dir = ShapeFieldsVisitor.getSegmentDirection(f1, f2);
        this.writeSegmentData(this.majorString, dir, semiMajor);
        dir = dir > 0.0 ? (dir -= 90.0) : (dir += 90.0);
        this.writeSegmentData(this.minorString, dir, semiMinor);
    }

    private void writeEccentricity(double semiMajor, double semiInterfocus) {
        double eccentricity = semiInterfocus / semiMajor;
        this.panel.addComputedValue(String.valueOf(this.eccentricityString) + " " + DOUBLE_FORMAT.format(eccentricity));
    }

    private void writeSegmentData(String name, double dir, double len) {
        this.panel.addComputedValue(String.valueOf(name) + " dir. " + DOUBLE_FORMAT.format(dir) + "; " + this.lengthString + " " + DOUBLE_FORMAT.format(len));
    }

    @Override
    public void visit(Line line) {
        if (line.isComplete()) {
            line.getPointReferences();
            List<ScriptoriumPoint> points = ShapeAdapter.getShapePoints(line, this.drawingPoints);
            Iterator<ScriptoriumPoint> iterator = points.iterator();
            ScriptoriumPoint one = iterator.next();
            int firstId = one.getId();
            Point2D first = one.getPoint2D();
            int ind = 0;
            ScriptoriumPoint two = iterator.next();
            int secondId = two.getId();
            Point2D second = two.getPoint2D();
            ind = 1;
            double dir1 = ShapeFieldsVisitor.getSegmentDirection(first, second);
            double len1 = ShapeFieldsVisitor.getSegmentLength(first, second);
            this.writeLineSegmentData(String.valueOf(ind), firstId, secondId, dir1, len1);
            while (iterator.hasNext()) {
                ScriptoriumPoint further = iterator.next();
                int furtherId = further.getId();
                Point2D fast = further.getPoint2D();
                ++ind;
                double firstX = first.getX();
                double firstY = first.getY();
                double secondX = second.getX();
                double secondY = second.getY();
                double fastX = fast.getX();
                double fastY = fast.getY();
                double delta1X = secondX - firstX;
                double delta1Y = secondY - firstY;
                double delta2X = fastX - secondX;
                double delta2Y = fastY - secondY;
                double cosNumerator = -delta1X * delta2X + -delta1Y * delta2Y;
                double cosDenominator = Math.sqrt(Math.pow(delta1X, 2.0) + Math.pow(delta1Y, 2.0)) * Math.sqrt(Math.pow(delta2X, 2.0) + Math.pow(delta2Y, 2.0));
                double angleCos = cosNumerator / cosDenominator;
                double angle = Math.toDegrees(Math.acos(angleCos));
                double dir2 = ShapeFieldsVisitor.getSegmentDirection(second, fast);
                double len2 = ShapeFieldsVisitor.getSegmentLength(second, fast);
                this.writeAngle(firstId, secondId, furtherId, angle, len1, len2);
                this.writeLineSegmentData(String.valueOf(ind), secondId, furtherId, dir2, len2);
                first = second;
                firstId = secondId;
                dir1 = dir2;
                len1 = len2;
                second = fast;
                secondId = furtherId;
            }
        }
    }

    private void writeAngle(int firstId, int secondId, int furtherId, double angle, double len1, double len2) {
        this.panel.addComputedValue("     " + this.angleString + "(" + firstId + "-" + secondId + "-" + furtherId + ") " + DOUBLE_FORMAT.format(angle) + "; " + this.ratioString + "(" + firstId + "-" + secondId + "/" + secondId + "-" + furtherId + ") " + DOUBLE_FORMAT.format(len1 / len2));
    }

    private void writeLineSegmentData(String name, int primo, int secondo, double dir, double len) {
        this.panel.addComputedValue(String.valueOf(name) + " (" + primo + "-" + secondo + ") dir. " + DOUBLE_FORMAT.format(dir) + "; " + this.lengthString + " " + DOUBLE_FORMAT.format(len));
    }

    private static double getSegmentLength(Point2D first, Point2D last) {
        return first.distance(last);
    }

    public static double getSegmentDirection(Point2D first, Point2D last) {
        double dir;
        double dy = last.getY() - first.getY();
        double dx = last.getX() - first.getX();
        if (dx == 0.0) {
            dir = dy >= 0.0 ? 90.0 : 270.0;
        } else {
            double slope = dy / dx;
            dir = Math.toDegrees(Math.atan(slope));
            if (dx < 0.0) {
                dir += 180.0;
            }
            if (dir < 0.0) {
                dir += 360.0;
            }
        }
        return dir;
    }

    @Override
    public void visit(Segment segment) {
    }
}

