/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings.points;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingArea;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingDirector;

public class PointThinMovementListener
implements KeyListener {
    private DrawingDirector drawingDirector;

    public void setDrawingDirector(DrawingDirector director) {
        this.drawingDirector = director;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        ScriptoriumPoint selectedPoint = this.drawingDirector.getSelectedPoint();
        if (selectedPoint != null && e.isShiftDown()) {
            double oldX = selectedPoint.getX();
            double oldY = selectedPoint.getY();
            Point2D.Double newPosition = null;
            switch (e.getKeyCode()) {
                case 37: {
                    newPosition = new Point2D.Double(oldX - 1.0, oldY);
                    break;
                }
                case 38: {
                    newPosition = new Point2D.Double(oldX, oldY + 1.0);
                    break;
                }
                case 39: {
                    newPosition = new Point2D.Double(oldX + 1.0, oldY);
                    break;
                }
                case 40: {
                    newPosition = new Point2D.Double(oldX, oldY - 1.0);
                }
            }
            if (newPosition != null) {
                this.drawingDirector.recordPointMove(selectedPoint, newPosition);
                selectedPoint.set(newPosition);
                DrawingArea drawingArea = this.drawingDirector.getDrawingArea();
                drawingArea.changeLayout();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

