/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.UITools;

public class WitnessPanel
extends ScriptoriumPanel<Witness> {
    private static final long serialVersionUID = 1L;
    private Conspectus conspectus;
    private DefaultGenericSelectionModel<Witness> witnesses;
    private int index;
    private Witness witness;
    private JTextField witnessId;
    private JTextField witnessTitle;
    private String witnessIdString;
    private String witnessTitleString;

    public WitnessPanel() {
        this.initLocale();
        Preferences preferences = Preferences.getInstance();
        this.witnessId = new JTextField(5);
        int fontSize = preferences.getInteger("text_fields_font_size");
        Color editableBgColor = preferences.getColor("text_fields_editable_bg_color");
        this.witnessId.setFont(this.witnessId.getFont().deriveFont(fontSize));
        this.witnessId.setBackground(editableBgColor);
        this.witnessId.setEditable(true);
        this.witnessTitle = new JTextField();
        this.witnessTitle.setFont(this.witnessTitle.getFont().deriveFont(fontSize));
        this.witnessTitle.setBackground(editableBgColor);
        this.witnessTitle.setEditable(true);
        JLabel witIdLabel = new JLabel(this.witnessIdString, 4);
        JLabel witTitLabel = new JLabel(this.witnessTitleString, 4);
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(Color.black));
        UITools.addComponent(this, witIdLabel, 0, 0, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, witTitLabel, 0, 1, 1, 1, 1, 1, 2, 2);
        UITools.addComponent(this, this.witnessId, 1, 0, 1, 1, 10, 1, 3, 2);
        UITools.addComponent(this, this.witnessTitle, 1, 1, 1, 1, 10, 10, 1, 2);
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        String locale = Preferences.getInstance().getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.witnessIdString = catalog.translate("witnessId");
        this.witnessTitleString = catalog.translate("witnessTitle");
    }

    public void setup(Conspectus conspectus, DefaultGenericSelectionModel<Witness> witnesses, int index) {
        this.conspectus = conspectus;
        this.witnesses = witnesses;
        this.index = index;
        this.witness = index >= 0 ? this.witnesses.get(index).makeCopy(new Witness()) : new Witness(this.conspectus);
        this.witnessId.setText(this.witness.getId());
        this.witnessTitle.setText(this.witness.getTitle());
    }

    @Override
    public boolean okAction() {
        this.witness.setId(this.witnessId.getText());
        this.witness.setTitle(this.witnessTitle.getText());
        if (this.index < 0) {
            this.witnesses.append(this.witness);
            this.conspectus.addWitness(this.witness);
        } else {
            this.conspectus.replaceWitness(this.witnesses.get(this.index), this.witness);
            this.witnesses.set(this.index, this.witness);
        }
        return super.okAction();
    }
}

