/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.points.ScriptoriumPoint;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.services.Highlighter;
import org.homelinux.elabor.tools.MessageCatalog;

public class EditionNodeRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private Iterable<ScriptoriumPoint> drawingPoints;
    private Iterable<ComputeAction> drawingActions;
    private OntologyInitialiser initialiser;

    public EditionNodeRenderer(OntologyInitialiser initialiser) {
        this.initLocale();
        this.initialiser = initialiser;
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
    }

    public void setDrawingPoints(Iterable<ScriptoriumPoint> drawingPoints) {
        this.drawingPoints = drawingPoints;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Highlighter highlighter = new Highlighter(this.initialiser);
        highlighter.setDrawingPoints(this.drawingPoints);
        highlighter.setDrawingActions(this.drawingActions);
        EditionComponent component = (EditionComponent)value;
        component.accept(highlighter);
        String text = highlighter.getText();
        this.setText(text);
        return this;
    }
}

