/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.exports;

import java.util.Comparator;
import java.util.Date;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReferenceInterface;
import org.homelinux.elabor.scriptorium.services.EditionManager;

class EditionComparator
implements Comparator<Edition> {
    private Ontology namesOntology;

    public EditionComparator() {
        EditionManager editionManager = EditionManager.getInstance();
        this.namesOntology = editionManager.getNamesOntology();
    }

    @Override
    public int compare(Edition e1, Edition e2) {
        Date d2;
        Header h1 = e1.getHeader();
        Header h2 = e2.getHeader();
        Date d1 = h1.getDate();
        int value = d1.compareTo(d2 = h2.getDate());
        if (value == 0) {
            String a1 = this.getAuthorValue(h1);
            String a2 = this.getAuthorValue(h2);
            value = a1.compareTo(a2);
        }
        if (value == 0) {
            String r1 = this.getReceiverValue(h1);
            String r2 = this.getReceiverValue(h2);
            value = r1.compareTo(r2);
        }
        return value;
    }

    private String getValue(OntologyReferenceInterface author) {
        return EditionManager.getOntologyOrder(this.namesOntology, author);
    }

    private String getAuthorValue(Header header) {
        OntologyReferenceInterface author = header.getAuthor();
        return this.getValue(author);
    }

    private String getReceiverValue(Header header) {
        OntologyReferenceInterface author = header.getReceiver();
        return this.getValue(author);
    }
}

