/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.iterators;

import java.util.Iterator;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementsIterator
implements Iterator<Element>,
Iterable<Element> {
    private Element child;

    public ElementsIterator(EditionComponent<?> component) {
        this.child = null;
        Element element = component.getElement();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int index = 0;
            while (index < nodeList.getLength()) {
                Node node = nodeList.item(index);
                if (node.getNodeType() == 1) {
                    this.child = (Element)node;
                    break;
                }
                ++index;
            }
        }
    }

    public ElementsIterator(Element first_element) {
        this.child = first_element;
    }

    @Override
    public boolean hasNext() {
        return this.child != null;
    }

    @Override
    public Element next() {
        Element next = this.child;
        boolean finished = false;
        Node brother = this.child;
        do {
            Node sibling;
            if ((sibling = brother.getNextSibling()) == null || sibling.getNodeType() == 1) {
                this.child = (Element)sibling;
                finished = true;
                continue;
            }
            brother = sibling;
        } while (!finished);
        return next;
    }

    @Override
    public void remove() {
    }

    @Override
    public Iterator<Element> iterator() {
        return this;
    }
}

