/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Author;
import org.homelinux.elabor.scriptorium.ecomponents.AuthorPlace;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.DescriptionItem;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponentBuilder;
import org.homelinux.elabor.scriptorium.ecomponents.EditionDate;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Identifier;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Publication;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ReadingReference;
import org.homelinux.elabor.scriptorium.ecomponents.Receiver;
import org.homelinux.elabor.scriptorium.ecomponents.ReceiverPlace;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Reference;
import org.homelinux.elabor.scriptorium.ecomponents.References;
import org.homelinux.elabor.scriptorium.ecomponents.Release;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Title;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.UnknownComponentException;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessId;
import org.homelinux.elabor.scriptorium.ecomponents.WitnessesIds;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.Arc;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.ScriptoriumStyle;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.w3c.dom.Element;

public class EditionComponentFactory {
    public static EditionComponent<?> createEditionElement(Element element, EditionListener listener) {
        EditionComponent component;
        String componentName = element.getNodeName();
        try {
            String upperCase = componentName.toUpperCase();
            ComponentType type = ComponentType.valueOf(upperCase);
            component = type.make(element, listener);
        }
        catch (Exception e) {
            if (componentName.equals("description")) {
                component = new Description(element);
            }
            if (componentName.equals("descriptionitem")) {
                component = new DescriptionItem(element);
            }
            if (componentName.equals("ontologyreference")) {
                component = new OntologyReference(element);
            }
            if (componentName.equals("edition")) {
                component = new Edition(element);
            }
            if (componentName.equals("header")) {
                component = new Header(element);
            }
            if (componentName.equals("conspectus")) {
                component = new Conspectus(element);
            }
            if (componentName.equals("witness")) {
                component = new Witness(element);
            }
            if (componentName.equals("content")) {
                component = new Content(element);
            }
            if (componentName.equals("reading")) {
                component = new Reading(element);
            }
            if (componentName.equals("readingreference")) {
                component = new ReadingReference(element);
            }
            if (componentName.equals("ids")) {
                component = new WitnessesIds(element);
            }
            if (componentName.equals("id")) {
                component = new WitnessId(element);
            }
            if (componentName.equals("variant")) {
                component = new Variant(element);
            }
            if (componentName.equals("variantitem")) {
                component = new VariantItem(element);
            }
            if (componentName.equals("annotation")) {
                component = new Annotation(element);
            }
            if (componentName.equals("citation")) {
                component = new Citation(element);
            }
            if (componentName.equals("crux")) {
                component = new Crux(element);
            }
            if (componentName.equals("date_token")) {
                component = new DateToken(element);
            }
            if (componentName.equals("enunciatio")) {
                component = new Enunciatio(element);
            }
            if (componentName.equals("expunctio")) {
                component = new Expunctio(element);
            }
            if (componentName.equals("math")) {
                component = new Formula(element);
            }
            if (componentName.equals("integratio")) {
                component = new Integratio(element);
            }
            if (componentName.equals("place")) {
                component = new Place(element);
            }
            if (componentName.equals("work")) {
                component = new Work(element);
            }
            if (componentName.equals("tongue")) {
                component = new Tongue(element);
            }
            if (componentName.equals("mathconcept")) {
                component = new MathConcept(element);
            }
            if (componentName.equals("name")) {
                component = new Name(element);
            }
            if (componentName.equals("drawing")) {
                component = new Drawing(element);
            }
            if (componentName.equals("style")) {
                component = new ScriptoriumStyle(element);
            }
            if (componentName.equals("styleset")) {
                component = new StyleSetReference(element);
            }
            if (componentName.equals(ComponentType.ARC.name())) {
                component = new Arc(element);
            }
            if (componentName.equals("text")) {
                component = new Text(element);
            }
            if (componentName.equals("comment")) {
                component = new Comment(element);
            }
            if (componentName.equals("references")) {
                component = new References(element);
            }
            if (componentName.equals("reference")) {
                component = new Reference(element);
            }
            if (componentName.equals("unit")) {
                component = new Unit(element);
            }
            if (componentName.equals("part")) {
                component = new TextPart(element);
            }
            if (componentName.equals("folium")) {
                component = new Folium(element);
            }
            if (componentName.equals("rtt")) {
                component = new Rectangulus(element);
            }
            if (componentName.equals("qdr")) {
                component = new Quadratus(element);
            }
            if (componentName.equals("title")) {
                component = new Title(element);
            }
            if (componentName.equals("identifier")) {
                component = new Identifier(element);
            }
            if (componentName.equals("sender")) {
                component = new Author(element);
            }
            if (componentName.equals("sender_place")) {
                component = new AuthorPlace(element);
            }
            if (componentName.equals("receiver")) {
                component = new Receiver(element);
            }
            if (componentName.equals("receiver_place")) {
                component = new ReceiverPlace(element);
            }
            if (componentName.equals("date")) {
                component = new EditionDate(element);
            }
            if (componentName.equals("publication")) {
                component = new Publication(element);
            }
            if (componentName.equals("release")) {
                component = new Release(element);
            }
            if (componentName.equals("listitem")) {
                component = new ListItem(element);
            }
            try {
                EditionComponentBuilder builder = EditionComponentBuilder.valueOf(componentName.toUpperCase());
                component = builder.buildComponent(element);
            }
            catch (Exception exc) {
                throw new UnknownComponentException(componentName);
            }
        }
        return component;
    }
}

