/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.File;
import java.net.URI;
import org.homelinux.elabor.scriptorium.ecomponents.AbstractValuedLeaf;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class AbstractImage<T extends EditionComponent<T>>
extends AbstractValuedLeaf<T>
implements ComponentFactory<T> {
    private static final String IMAGE_NAME = "name";

    public AbstractImage() {
        super(IMAGE_NAME);
    }

    public AbstractImage(EditionComponent<?> parent) {
        super(parent, IMAGE_NAME);
    }

    public AbstractImage(Element element) {
        super(element, IMAGE_NAME);
        Attr node = element.getAttributeNode(IMAGE_NAME);
        if (node == null) {
            this.setValue("");
        }
    }

    public void setUri(URI uri) {
        this.setValue(uri.toString());
    }

    public URI getUri() {
        String imageName = this.getValue();
        return URI.create(imageName);
    }

    @Override
    public void relativize(File oldDir, File newDir) {
        URI fileURI;
        URI newURI = newDir.toURI();
        String imagePath = this.getStringAttribute(IMAGE_NAME);
        if (oldDir == null) {
            try {
                fileURI = newURI.resolve(imagePath);
            }
            catch (Exception exc) {
                File file = new File(imagePath);
                fileURI = file.toURI();
            }
        } else {
            URI oldURI = oldDir.toURI();
            fileURI = oldURI.resolve(imagePath);
        }
        URI relURI = newURI.relativize(fileURI);
        String imageRelativeURI = relURI.toString();
        this.setStringAttribute(IMAGE_NAME, imageRelativeURI);
    }
}

