/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db.generic;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.generic.FieldManager;
import org.homelinux.elabor.db.generic.Setter;

public class GenericRecordCreator<R>
implements RecordCreator<R> {
    private static final Class<Setter> SETTER_CLASS = Setter.class;
    private Class<R> recordClass;
    private List<FieldManager<R>> managers;

    public GenericRecordCreator(Object dao, Class<R> recordClass) throws NoSuchMethodException {
        this.recordClass = recordClass;
        Method[] methods = recordClass.getMethods();
        this.managers = new ArrayList<FieldManager<R>>();
        for (Method method : methods) {
            Setter setter = method.getAnnotation(SETTER_CLASS);
            if (setter == null) continue;
            String name = setter.field();
            String getterName = setter.getter();
            FieldManager manager = new FieldManager(method, dao, name, getterName);
            this.managers.add(manager);
        }
    }

    @Override
    public R createRecord(ResultSet rs) {
        R record;
        try {
            record = this.recordClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (FieldManager<R> manager : this.managers) {
                manager.fillField(record, rs);
            }
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
        return record;
    }
}

