/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.homelinux.elabor.db.RecordCreator;

public class DateCreator
implements RecordCreator<Date> {
    private final String name;
    private final DateFormat dateFormat;
    private final boolean nullable;

    public DateCreator(String name) {
        this(name, null);
    }

    public DateCreator(String name, DateFormat dateFormat) {
        this(name, dateFormat, false);
    }

    public DateCreator(String name, DateFormat dateFormat, boolean nullable) {
        this.name = name;
        this.dateFormat = dateFormat;
        this.nullable = nullable;
    }

    @Override
    public Date createRecord(ResultSet rs) throws SQLException {
        return this.name == null ? rs.getTimestamp(1) : this.getDate(rs);
    }

    private Date getDate(ResultSet rs) throws SQLException {
        Date date;
        if (this.dateFormat == null) {
            date = rs.getDate(this.name);
        } else {
            try {
                String value = rs.getString(this.name);
                date = this.nullable && value == null ? null : this.dateFormat.parse(value);
            }
            catch (ParseException exc) {
                throw new RuntimeException(exc);
            }
        }
        return date;
    }
}

