select mno.* from (
	SELECT
		mno.*,
		row_number() over (ORDER BY
			DATA_MISURA DESC,
			COD_FLUSSO DESC,
			DATA_PUBBLICAZIONE_FILE DESC,
			DATA_IMPORT_FILE DESC,
			ID DESC) as seqnum
	FROM misure_pod_non_orari mno
	WHERE
		pod_id = :codice_pod: AND
		cod_flusso IN ('VNO','VNO2G','RNO','RNO2G') AND
		TO_CHAR(data_misura, 'YYYY-MM-DD') >= :data_min: AND
		TO_CHAR(data_misura, 'YYYY-MM-DD') <= :data_max: AND
		STATO IN (4,5,6,8)
) mno where seqnum=1
