SELECT mp.*, mpe.*, mpr.*, mpp.*, mpe.data AS data_att,
case when cod_flusso in ('RFO', 'RFO2G') then data_rilevazione else null end as data_ril
FROM
	misure_pod_orari mp,
	misure_pod_orari_ea mpe,
	misure_pod_orari_er mpr
	left join misure_pod_orari_pot mpp
		on (mpr.misure_pod_orari_id=mpp.misure_pod_orari_id and mpr.data=mpp.data)
WHERE
	azienda-clause
	export-clause
	pod-clause
	date-clause
	regime-clause
	raccolta-clause
	mpr.misure_pod_orari_id=mp.id AND
	mpe.misure_pod_orari_id=mp.id AND
	mpe.data=mpr.data AND
	mp.cod_flusso in (:flussi) AND
	stato IN (:stati) AND 
	mpr.tipo_rea = 'T'
ORDER BY mp.pod_id, mpe.data, data_ril
