/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchUpdateUtils {
    public static int[] executeBatchUpdate(String sql, final List<Object[]> batchValues, final int[] columnTypes, JdbcOperations jdbcOperations) {
        return jdbcOperations.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i2) throws SQLException {
                Object[] values = (Object[])batchValues.get(i2);
                BatchUpdateUtils.setStatementParameters(values, ps, columnTypes);
            }

            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    protected static void setStatementParameters(Object[] values, PreparedStatement ps, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        Object[] objectArray = values;
        int n2 = values.length;
        int n3 = 0;
        while (n3 < n2) {
            Object value = objectArray[n3];
            ++colIndex;
            if (value instanceof SqlParameterValue) {
                SqlParameterValue paramValue = (SqlParameterValue)value;
                StatementCreatorUtils.setParameterValue(ps, colIndex, paramValue, paramValue.getValue());
            } else {
                int colType = columnTypes == null || columnTypes.length < colIndex ? Integer.MIN_VALUE : columnTypes[colIndex - 1];
                StatementCreatorUtils.setParameterValue(ps, colIndex, colType, value);
            }
            ++n3;
        }
    }
}

