/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnnotationAttributesReadingVisitor
implements AnnotationVisitor {
    private final String annotationType;
    private final Map<String, Map<String, Object>> attributesMap;
    private final Map<String, Set<String>> metaAnnotationMap;
    private final ClassLoader classLoader;
    private final Map<String, Object> localAttributes = new LinkedHashMap<String, Object>();

    public AnnotationAttributesReadingVisitor(String annotationType, Map<String, Map<String, Object>> attributesMap, Map<String, Set<String>> metaAnnotationMap, ClassLoader classLoader) {
        this.annotationType = annotationType;
        this.attributesMap = attributesMap;
        this.metaAnnotationMap = metaAnnotationMap;
        this.classLoader = classLoader;
    }

    @Override
    public void visit(String name, Object value) {
        this.localAttributes.put(name, value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        Object valueToUse = value;
        try {
            Class<?> enumType = this.classLoader.loadClass(Type.getType(desc).getClassName());
            Field enumConstant = ReflectionUtils.findField(enumType, value);
            if (enumConstant != null) {
                valueToUse = enumConstant.get(null);
            }
        }
        catch (Exception exception) {}
        this.localAttributes.put(name, valueToUse);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return new EmptyVisitor();
    }

    @Override
    public AnnotationVisitor visitArray(final String attrName) {
        return new AnnotationVisitor(){

            public void visit(String name, Object value) {
                Object[] newValue = value;
                Object existingValue = AnnotationAttributesReadingVisitor.this.localAttributes.get(attrName);
                if (existingValue != null) {
                    newValue = ObjectUtils.addObjectToArray((Object[])existingValue, newValue);
                } else {
                    Object[] newArray = (Object[])Array.newInstance(newValue.getClass(), 1);
                    newArray[0] = newValue;
                    newValue = newArray;
                }
                AnnotationAttributesReadingVisitor.this.localAttributes.put(attrName, newValue);
            }

            public void visitEnum(String name, String desc, String value) {
            }

            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new EmptyVisitor();
            }

            public AnnotationVisitor visitArray(String name) {
                return new EmptyVisitor();
            }

            public void visitEnd() {
            }
        };
    }

    @Override
    public void visitEnd() {
        this.attributesMap.put(this.annotationType, this.localAttributes);
        try {
            Method[] annotationAttributes;
            Class<?> annotationClass = this.classLoader.loadClass(this.annotationType);
            Method[] methodArray = annotationAttributes = annotationClass.getMethods();
            int n2 = annotationAttributes.length;
            int n3 = 0;
            while (n3 < n2) {
                Method annotationAttribute = methodArray[n3];
                String attributeName = annotationAttribute.getName();
                Object defaultValue = annotationAttribute.getDefaultValue();
                if (defaultValue != null && !this.localAttributes.containsKey(attributeName)) {
                    this.localAttributes.put(attributeName, defaultValue);
                }
                ++n3;
            }
            LinkedHashSet<String> metaAnnotationTypeNames = new LinkedHashSet<String>();
            Annotation[] annotationArray = annotationClass.getAnnotations();
            int n4 = annotationArray.length;
            n2 = 0;
            while (n2 < n4) {
                Annotation metaAnnotation = annotationArray[n2];
                metaAnnotationTypeNames.add(metaAnnotation.annotationType().getName());
                if (!this.attributesMap.containsKey(metaAnnotation.annotationType().getName())) {
                    this.attributesMap.put(metaAnnotation.annotationType().getName(), AnnotationUtils.getAnnotationAttributes(metaAnnotation, true));
                }
                Annotation[] annotationArray2 = metaAnnotation.annotationType().getAnnotations();
                int n5 = annotationArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    Annotation metaMetaAnnotation = annotationArray2[n6];
                    metaAnnotationTypeNames.add(metaMetaAnnotation.annotationType().getName());
                    ++n6;
                }
                ++n2;
            }
            if (this.metaAnnotationMap != null) {
                this.metaAnnotationMap.put(this.annotationType, metaAnnotationTypeNames);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }
}

