/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm.commons;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.asm.ClassAdapter;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.commons.SerialVersionUIDAdder$Item;

public class SerialVersionUIDAdder
extends ClassAdapter {
    protected boolean computeSVUID;
    protected boolean hasSVUID;
    protected int access;
    protected String name;
    protected String[] interfaces;
    protected Collection svuidFields = new ArrayList();
    protected boolean hasStaticInitializer;
    protected Collection svuidConstructors = new ArrayList();
    protected Collection svuidMethods = new ArrayList();

    public SerialVersionUIDAdder(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        boolean bl = this.computeSVUID = (n3 & 0x200) == 0;
        if (this.computeSVUID) {
            this.name = string;
            this.access = n3;
            this.interfaces = stringArray;
        }
        super.visit(n2, n3, string, string2, string3, stringArray);
    }

    public MethodVisitor visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        if (this.computeSVUID) {
            if (string.equals("<clinit>")) {
                this.hasStaticInitializer = true;
            }
            int n3 = n2 & 0xD3F;
            if ((n2 & 2) == 0) {
                if (string.equals("<init>")) {
                    this.svuidConstructors.add(new SerialVersionUIDAdder$Item(string, n3, string2));
                } else if (!string.equals("<clinit>")) {
                    this.svuidMethods.add(new SerialVersionUIDAdder$Item(string, n3, string2));
                }
            }
        }
        return this.cv.visitMethod(n2, string, string2, string3, stringArray);
    }

    public FieldVisitor visitField(int n2, String string, String string2, String string3, Object object) {
        if (this.computeSVUID) {
            if (string.equals("serialVersionUID")) {
                this.computeSVUID = false;
                this.hasSVUID = true;
            }
            int n3 = n2 & 0xDF;
            if ((n2 & 2) == 0 || (n2 & 0x88) == 0) {
                this.svuidFields.add(new SerialVersionUIDAdder$Item(string, n3, string2));
            }
        }
        return super.visitField(n2, string, string2, string3, object);
    }

    public void visitEnd() {
        if (this.computeSVUID && !this.hasSVUID) {
            try {
                this.cv.visitField(24, "serialVersionUID", "J", null, new Long(this.computeSVUID()));
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Error while computing SVUID for " + this.name, throwable);
            }
        }
        super.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeSVUID() throws IOException {
        if (this.hasSVUID) {
            return 0L;
        }
        ByteArrayOutputStream byteArrayOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        long l2 = 0L;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeUTF(this.name.replace('/', '.'));
            ((DataOutputStream)filterOutputStream).writeInt(this.access & 0x611);
            Arrays.sort(this.interfaces);
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                ((DataOutputStream)filterOutputStream).writeUTF(this.interfaces[i2].replace('/', '.'));
            }
            this.writeItems(this.svuidFields, (DataOutputStream)filterOutputStream, false);
            if (this.hasStaticInitializer) {
                ((DataOutputStream)filterOutputStream).writeUTF("<clinit>");
                ((DataOutputStream)filterOutputStream).writeInt(8);
                ((DataOutputStream)filterOutputStream).writeUTF("()V");
            }
            this.writeItems(this.svuidConstructors, (DataOutputStream)filterOutputStream, true);
            this.writeItems(this.svuidMethods, (DataOutputStream)filterOutputStream, true);
            ((DataOutputStream)filterOutputStream).flush();
            byte[] byArray = this.computeSHAdigest(byteArrayOutputStream.toByteArray());
            for (int i3 = Math.min(byArray.length, 8) - 1; i3 >= 0; --i3) {
                l2 = l2 << 8 | (long)(byArray[i3] & 0xFF);
            }
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
        return l2;
    }

    protected byte[] computeSHAdigest(byte[] byArray) {
        try {
            return MessageDigest.getInstance("SHA").digest(byArray);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    private void writeItems(Collection collection, DataOutputStream dataOutputStream, boolean bl) throws IOException {
        int n2 = collection.size();
        Object[] objectArray = collection.toArray(new SerialVersionUIDAdder$Item[n2]);
        Arrays.sort(objectArray);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutputStream.writeUTF(((SerialVersionUIDAdder$Item)objectArray[i2]).name);
            dataOutputStream.writeInt(((SerialVersionUIDAdder$Item)objectArray[i2]).access);
            dataOutputStream.writeUTF(bl ? ((SerialVersionUIDAdder$Item)objectArray[i2]).desc.replace('/', '.') : ((SerialVersionUIDAdder$Item)objectArray[i2]).desc);
        }
    }
}

