/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.Util;
import org.slf4j.impl.StaticLoggerBinder;

public final class LoggerFactory {
    static ILoggerFactory loggerFactory;
    static final String NO_STATICLOGGERBINDER_URL = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String NULL_LF_URL = "http://www.slf4j.org/codes.html#null_LF";

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        if (loggerFactory == null) {
            throw new IllegalStateException("Logging factory implementation cannot be null. See also http://www.slf4j.org/codes.html#null_LF");
        }
        return loggerFactory.getLogger(clazz.getName());
    }

    public static ILoggerFactory getILoggerFactory() {
        return loggerFactory;
    }

    static {
        try {
            loggerFactory = StaticLoggerBinder.SINGLETON.getLoggerFactory();
        }
        catch (NoClassDefFoundError ncde) {
            String msg = ncde.getMessage();
            if (msg != null && msg.indexOf("org/slf4j/impl/StaticLoggerBinder") != -1) {
                Util.reportFailure("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                Util.reportFailure("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
            }
            throw ncde;
        }
        catch (Exception e2) {
            Util.reportFailure("Failed to instantiate logger [" + StaticLoggerBinder.SINGLETON.getLoggerFactoryClassStr() + "]", e2);
        }
    }
}

