/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.tools;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTreeNode {
    private Element element;

    public XMLTreeNode(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public List<XMLTreeNode> getChildren() {
        ArrayList<XMLTreeNode> children = new ArrayList<XMLTreeNode>();
        Node child = this.element.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                children.add(new XMLTreeNode((Element)child));
            }
            child = child.getNextSibling();
        }
        return children;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public int getIndexOfChild(XMLTreeNode child) {
        return this.getChildren().indexOf(child);
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void addChild(XMLTreeNode child) {
        this.getElement().appendChild(child.getElement());
    }

    public XMLTreeNode getChild(int index) {
        return this.getChildren().get(index);
    }

    public boolean equals(Object object) {
        return object instanceof XMLTreeNode ? this.getElement() == ((XMLTreeNode)object).getElement() : false;
    }

    public void setAttribute(String name, String value) {
        this.getElement().setAttribute(name, value);
    }

    public String getAttribute(String string) {
        return this.getElement().getAttribute(string);
    }

    public int hashCode() {
        return this.getElement().hashCode();
    }
}

