/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.homelinux.elabor.springtools.domain.attachment.Attachment;
import org.homelinux.elabor.springtools.domain.attachment.AttachmentContainer;
import org.homelinux.elabor.springtools.domain.attachment.Picture;
import org.homelinux.elabor.springtools.services.PictureManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class DownloadController {
    public static final String CONTAINER = "container";
    @Autowired
    private PictureManager pictureManager;

    public abstract Attachment loadAttachment(Integer var1);

    public void setPictureManager(PictureManager manager) {
        this.pictureManager = manager;
    }

    private static void setUpFileResponse(Attachment attachment, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + attachment.getFileName() + "\"");
        response.setBufferSize(attachment.getSize().intValue());
        response.setContentType(attachment.getContentType());
        response.setContentLength(attachment.getSize().intValue());
        ServletOutputStream ouputStream = response.getOutputStream();
        ouputStream.write(attachment.getContent(), 0, attachment.getSize().intValue());
        ouputStream.flush();
        ouputStream.close();
    }

    private void returnThumbnail(String size, HttpServletResponse response, Attachment attachment) throws IOException {
        Picture picture = Picture.getPicture(attachment);
        if (picture != null) {
            Attachment thumb = this.pictureManager.getThumbnail(size, picture);
            DownloadController.setUpFileResponse(thumb, response);
        }
    }

    @RequestMapping(value={"/thumbnail.html"}, params={"fileId", "size"})
    public String download(@RequestParam(value="fileId") Integer fileId, @RequestParam(value="size") String size, HttpServletResponse response) throws IOException {
        Attachment attachment = this.loadAttachment(fileId);
        this.returnThumbnail(size, response, attachment);
        return null;
    }

    @RequestMapping(value={"/thumbnail.html"}, params={"fileName", "size"})
    public String download(@ModelAttribute(value="container") AttachmentContainer container, @RequestParam(value="fileName") String fileName, @RequestParam(value="size") String size, HttpServletResponse response) throws IOException {
        for (Attachment attachment : container.getAttachments()) {
            if (!attachment.getFileName().equals(fileName)) continue;
            this.returnThumbnail(size, response, attachment);
            break;
        }
        return null;
    }

    @RequestMapping(value={"/download.html"}, params={"fileId"})
    public void download(@RequestParam(value="fileId") Integer fileId, HttpServletResponse response) throws IOException {
        Attachment attachment = this.loadAttachment(fileId);
        DownloadController.setUpFileResponse(attachment, response);
    }

    @RequestMapping(value={"/download.html"}, params={"fileName"})
    public void download(@ModelAttribute(value="container") AttachmentContainer container, @RequestParam(value="fileName") String fileName, HttpServletResponse response) throws IOException {
        for (Attachment attachment : container.getAttachments()) {
            if (!attachment.getFileName().equals(fileName)) continue;
            DownloadController.setUpFileResponse(attachment, response);
            break;
        }
    }
}

