/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.taglib.graphics;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.springtools.taglib.graphics.Curve;
import org.homelinux.elabor.springtools.taglib.graphics.InvalidSizeException;

public class GraphicData {
    private List<Curve> curves = new ArrayList<Curve>();
    private double maxValue = 0.0;
    private int length = 0;

    public void add(Curve curve) throws InvalidSizeException {
        if (!curve.isEmpty()) {
            int size = curve.size();
            if (this.curves.isEmpty() || size == this.length) {
                this.maxValue = Math.max(this.maxValue, curve.getMaxValue());
                this.length = size;
                this.curves.add(curve);
            } else {
                throw new InvalidSizeException(this.length, size);
            }
        }
    }

    public List<Curve> getCurves() {
        return this.curves;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.curves.isEmpty();
    }
}

