/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.print;

import com.itextpdf.text.pdf.Barcode;
import com.itextpdf.text.pdf.Barcode128;
import java.awt.Color;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import org.homelinux.elabor.file.FileSystemTools;
import org.homelinux.elabor.print.DymoPainter;

public class DymoPrinter {
    private static final double MARGIN_LEFT = 0.0;
    private static final double MARGIN_RIGHT = 0.0;
    private static final double MARGIN_UP = 20.0;
    private static final double MARGIN_DOWN = 0.0;
    private static final double WIDTH = 160.0;
    private static final double HEIGHT = 260.0;
    private String name;

    public static void main(String[] args) throws PrinterException, IOException {
        ArrayList<String> values = new ArrayList<String>();
        values.add("IMEI: 356954068509023");
        values.add("Apple iPhone 5S");
        values.add("White 16GB A - 231");
        DymoPrinter dymo = new DymoPrinter("dymo");
        dymo.print("356954068509023", values, false);
    }

    public DymoPrinter(String name) {
        this.name = name;
    }

    public void print(String barcode, List<String> values, boolean filePrint) throws PrinterException, IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.getPrintService() == null) {
            throw new PrinterException("nessuna stampante disponibile");
        }
        logger.info("search printer: " + this.name);
        PrintService service = DymoPrinter.findPrintService(this.name);
        if (service == null || filePrint) {
            File file = FileSystemTools.createTempFile("etichetta", ".ps");
            URI fileUri = file.toURI();
            Destination destination = new Destination(fileUri);
            attributes.add(destination);
            logger.info("stampa su file: " + file.getAbsolutePath());
        } else {
            job.setPrintService(service);
            logger.info("stampante: " + service.getName());
        }
        DymoPainter painter = new DymoPainter(barcode, values);
        PageFormat pageFormat = DymoPrinter.buildPageFormat();
        job.setPrintable(painter, pageFormat);
        job.print(attributes);
    }

    private static PrintService findPrintService(String name) {
        PrintService service = null;
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        int n2 = printServiceArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PrintService current = printServiceArray[n3];
            String serviceName = current.getName();
            System.out.println("trovata coda di stampa: " + serviceName);
            if (serviceName.toLowerCase().contains(name.toLowerCase())) {
                service = current;
            }
            ++n3;
        }
        return service;
    }

    private static PageFormat buildPageFormat() {
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        paper.setSize(160.0, 260.0);
        paper.setImageableArea(0.0, 20.0, 160.0, 240.0);
        pageFormat.setPaper(paper);
        pageFormat.setOrientation(1);
        return pageFormat;
    }

    public static Image buildBarcodeImage(String text) {
        Barcode128 barcode = new Barcode128();
        barcode.setGenerateChecksum(true);
        ((Barcode)barcode).setCode(text);
        barcode.setBarHeight(10.0f);
        barcode.setSize(10.0f);
        return ((Barcode)barcode).createAwtImage(Color.BLACK, Color.WHITE);
    }
}

