/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.poi.openxml4j.util.ZipArchiveThresholdInputStream;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.homelinux.elabor.file.FolderWriterAction;
import org.homelinux.elabor.file.NotDirectoryException;
import org.homelinux.elabor.file.PatternFileFilter;
import org.homelinux.elabor.file.ZipInputStreamAction;
import org.homelinux.elabor.text.NewLine;

public class FileSystemTools {
    private FileSystemTools() {
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------"));
        File file = Files.createTempFile(prefix, suffix, attr).toFile();
        boolean ok = file.setReadable(true, true);
        ok &= file.setWritable(true, true);
        if (!(ok &= file.setExecutable(true, true))) {
            throw new RuntimeException("failed to create temporary file");
        }
        return file;
    }

    public static File derive(File file, String extension) {
        File parent = file.getParentFile();
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        name = String.valueOf(name) + '.' + extension;
        return new File(parent, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File copy(File source, File destination) throws IOException {
        File output = destination.isDirectory() ? new File(destination, source.getName()) : destination;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                block24: {
                    FileChannel inputChannel = inputStream.getChannel();
                    try {
                        block23: {
                            FileOutputStream outputStream = new FileOutputStream(output);
                            try {
                                try (FileChannel outputChannel = outputStream.getChannel();){
                                    inputChannel.transferTo(0L, source.length(), outputChannel);
                                }
                                if (outputStream == null) break block23;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (outputStream == null) throw throwable;
                                outputStream.close();
                                throw throwable;
                            }
                            outputStream.close();
                        }
                        if (inputChannel == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (inputChannel == null) throw throwable;
                        inputChannel.close();
                        throw throwable;
                    }
                    inputChannel.close();
                }
                if (inputStream == null) return output;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return output;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void read(File file, Writer writer) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileReader input = new FileReader(file);
            try {
                try (BufferedReader reader = new BufferedReader(input);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        writer.write(String.valueOf(line) + NewLine.NEW_LINE);
                    }
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File zipFile, File folder) throws IOException {
        final Path path = Paths.get(folder.getAbsolutePath(), new String[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(zipFile);
            try {
                try (final ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                            Path targetFile = path.relativize(file);
                            zipOutputStream.putNextEntry(new ZipEntry(targetFile.toString()));
                            byte[] bytes = Files.readAllBytes(file);
                            zipOutputStream.write(bytes, 0, bytes.length);
                            zipOutputStream.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                if (outputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void unzip(File zippedFile, File folder) throws IOException {
        FolderWriterAction folderWriter = new FolderWriterAction(folder);
        FileSystemTools.unzip(zippedFile, folderWriter);
    }

    public static long unzip(File zippedFile, ZipInputStreamAction folderWriter) throws IOException, ZipException {
        long size = 0L;
        Throwable throwable = null;
        Object var5_5 = null;
        try (ZipSecureFile zipFile = new ZipSecureFile(zippedFile);){
            Enumeration<ZipArchiveEntry> zipEntries = zipFile.getEntries();
            while (zipEntries.hasMoreElements()) {
                ZipArchiveEntry zipEntry = zipEntries.nextElement();
                Throwable throwable2 = null;
                Object var10_12 = null;
                try (ZipArchiveThresholdInputStream zipInputStream = zipFile.getInputStream(zipEntry);){
                    size += folderWriter.execute(zipInputStream, zipEntry);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return size;
    }

    public static boolean isChildren(File folder, File file) {
        File parent = file.getParentFile();
        while (parent != null && !parent.equals(folder)) {
            parent = parent.getParentFile();
        }
        return parent != null;
    }

    public static URI getRelativeURI(File folder, File file) {
        URI folderURI = folder.toURI().normalize();
        URI fileURI = file.toURI().normalize();
        return folderURI.relativize(fileURI);
    }

    public static File getFileFromUri(File folder, URI file) {
        URI folderURI = folder.toURI().normalize();
        URI fileUri = folderURI.resolve(file);
        return new File(fileUri);
    }

    public static boolean clean(File file) {
        boolean ok = true;
        if (file.exists()) {
            File[] children;
            if (file.isDirectory() && (children = file.listFiles()) != null) {
                File[] fileArray = children;
                int n2 = children.length;
                int n3 = 0;
                while (n3 < n2) {
                    File child = fileArray[n3];
                    ok &= FileSystemTools.clean(child);
                    ++n3;
                }
            }
            ok &= file.delete();
        }
        return ok;
    }

    @Deprecated
    public static void folderCopy(File source, File destination) throws NotDirectoryException, IOException {
        String loggerName = FileSystemTools.class.getName();
        Logger logger = Logger.getLogger(loggerName);
        FileSystemTools.folderCopy(source, destination, logger);
    }

    public static void folderCopy(File source, File destination, Logger logger) throws NotDirectoryException, IOException {
        logger.info("copying " + source.getAbsolutePath() + " to " + destination.getAbsolutePath());
        if (!source.isDirectory()) {
            throw new NotDirectoryException("invalid.file", source);
        }
        if (!destination.isDirectory()) {
            throw new NotDirectoryException("invalid.file", destination);
        }
        File[] files = source.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n2 = files.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray[n3];
                if (file.isDirectory()) {
                    FileSystemTools.folderToFolderCopy(file, destination, logger);
                } else {
                    FileSystemTools.copy(file, destination);
                }
                ++n3;
            }
        }
    }

    private static void folderToFolderCopy(File source, File destination, Logger logger) throws NotDirectoryException, IOException {
        File output = new File(destination, source.getName());
        output.mkdir();
        FileSystemTools.folderCopy(source, output, logger);
    }

    public static FilenameFilter getNullFileFilter() {
        return new PatternFileFilter(".*", "tutti i file");
    }
}

