/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.excel;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JFileChooser;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.read.biff.BiffException;

public class ExcelReader {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");

    public static void main(String[] args) throws IOException {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(null);
        File file = chooser.getSelectedFile();
        ExcelReader.printFile(file);
    }

    private static void printFile(File file) throws IOException {
        System.out.println("file:\t" + file.getName());
        try {
            Workbook w = Workbook.getWorkbook(file);
            Sheet[] sheetArray = w.getSheets();
            int n2 = sheetArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Sheet sheet = sheetArray[n3];
                ExcelReader.printSheet(sheet);
                ++n3;
            }
        }
        catch (BiffException e2) {
            e2.printStackTrace();
        }
    }

    private static void printSheet(Sheet sheet) {
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm");
        DATE_FORMAT.setTimeZone(GMT_TIMEZONE);
        System.out.println("foglio:\t" + sheet.getName());
        int i2 = 0;
        while (i2 < sheet.getRows()) {
            int j2 = 0;
            while (j2 < sheet.getColumns()) {
                Colour color;
                Cell cell = sheet.getCell(j2, i2);
                CellType type = cell.getType();
                CellFormat format = cell.getCellFormat();
                if (format != null && (color = format.getBackgroundColour()) != Colour.DEFAULT_BACKGROUND) {
                    System.out.print(color.getDescription());
                }
                if (type == CellType.NUMBER) {
                    NumberCell numCell = (NumberCell)cell;
                    double value = numCell.getValue();
                    System.out.print(value);
                } else if (type == CellType.DATE) {
                    DateCell dateCell = (DateCell)cell;
                    Date value = dateCell.getDate();
                    System.out.print(DATE_FORMAT.format(value));
                } else {
                    String contents = cell.getContents();
                    System.out.print(contents);
                }
                System.out.print("\t");
                ++j2;
            }
            System.out.println();
            ++i2;
        }
    }
}

