/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.homelinux.elabor.text.NewLine;

public class CsvWriter {
    private Writer writer;
    private String delimiter;
    private String separator;

    public CsvWriter() {
        this("\"", ",");
    }

    public CsvWriter(String delimiter, String separator) {
        this.setDelimiter(delimiter);
        this.setSeparator(separator);
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setFile(File file) throws IOException {
        this.writer = new FileWriter(file);
    }

    public void writeRow(String[] row) throws IOException {
        int index = 0;
        while (index < row.length) {
            this.writer.write(String.valueOf(this.delimiter) + (row[index] == null ? "" : row[index]) + this.delimiter);
            if (row.length - index > 1) {
                this.writer.write(this.separator);
            }
            ++index;
        }
        this.writer.write(NewLine.NEW_LINE);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

