/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.displaytag.util.Href;

public class PostHref
implements Href {
    private static final long serialVersionUID = 899149338534L;
    private Href parent;
    private String form;

    public PostHref(Href parent, String form) {
        this.parent = parent;
        this.form = form;
    }

    public Href addParameter(String name, Object value) {
        this.parent.addParameter(name, value);
        return this;
    }

    public Href addParameter(String name, int value) {
        this.parent.addParameter(name, value);
        return this;
    }

    public void addParameterMap(Map parametersMap) {
        this.parent.addParameterMap(parametersMap);
    }

    public boolean equals(Object object) {
        return ((Object)this.parent).equals(object);
    }

    public String getAnchor() {
        return this.parent.getAnchor();
    }

    public String getBaseUrl() {
        return this.parent.getBaseUrl();
    }

    public Map getParameterMap() {
        return this.parent.getParameterMap();
    }

    public void removeParameter(String name) {
        this.parent.removeParameter(name);
    }

    public void setAnchor(String name) {
        this.parent.setAnchor(name);
    }

    public void setFullUrl(String url) {
        this.parent.setFullUrl(url);
    }

    public void setParameterMap(Map parametersMap) {
        this.parent.setParameterMap(parametersMap);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("javascript:displaytagform('");
        buffer.append(this.form);
        buffer.append("',[");
        Map parameters = this.getParameterMap();
        Set parameterSet = parameters.entrySet();
        Iterator iterator = parameterSet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            buffer.append("{f:'");
            buffer.append(this.esc(key));
            buffer.append("',v:");
            if (value != null && value.getClass().isArray()) {
                Object[] values = (Object[])value;
                buffer.append("[");
                for (int i2 = 0; i2 < values.length; ++i2) {
                    if (i2 > 0) {
                        buffer.append(",");
                    }
                    buffer.append("'");
                    buffer.append(this.esc(values[i2]));
                    buffer.append("'");
                }
                buffer.append("]");
            } else {
                buffer.append("'");
                buffer.append(this.esc(value));
                buffer.append("'");
            }
            buffer.append("}");
            if (!iterator.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("])");
        return buffer.toString();
    }

    private String esc(Object value) {
        try {
            String param = URLDecoder.decode(ObjectUtils.toString(value), "utf-8");
            param = StringUtils.replace(param, "'", "\\'");
            param = StringUtils.replace(param, "\"", "%22");
            return param;
        }
        catch (UnsupportedEncodingException e2) {
            throw new UnhandledException(e2);
        }
    }

    public Object clone() {
        PostHref href;
        try {
            href = (PostHref)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new UnhandledException(e2);
        }
        href.parent = (Href)this.parent.clone();
        return href;
    }
}

