/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.exception.ObjectLookupException;

public final class LookupUtil {
    private static Log log = LogFactory.getLog(LookupUtil.class);

    private LookupUtil() {
    }

    public static Object getBeanValue(PageContext pageContext, String beanAndPropertyName, int scope) throws ObjectLookupException {
        if (beanAndPropertyName.indexOf(46) != -1) {
            Object beanObject;
            String objectName = StringUtils.substringBefore(beanAndPropertyName, ".");
            String beanProperty = StringUtils.substringAfter(beanAndPropertyName, ".");
            if (log.isDebugEnabled()) {
                log.debug("getBeanValue - bean: {" + objectName + "}, property: {" + beanProperty + "}");
            }
            if ((beanObject = pageContext.getAttribute(objectName, scope)) == null) {
                return null;
            }
            return LookupUtil.getBeanProperty(beanObject, beanProperty);
        }
        if (log.isDebugEnabled()) {
            log.debug("getBeanValue - bean: {" + beanAndPropertyName + "}");
        }
        return pageContext.getAttribute(beanAndPropertyName, scope);
    }

    public static Object getBeanProperty(Object bean, String name) throws ObjectLookupException {
        Validate.notNull(bean, "No bean specified");
        Validate.notNull(name, "No name specified");
        if (log.isDebugEnabled()) {
            log.debug("getProperty [" + name + "] on bean " + bean);
        }
        try {
            return LookupUtil.getProperty(bean, name);
        }
        catch (IllegalAccessException e2) {
            throw new ObjectLookupException(LookupUtil.class, bean, name, e2);
        }
        catch (InvocationTargetException e3) {
            throw new ObjectLookupException(LookupUtil.class, bean, name, e3);
        }
        catch (NoSuchMethodException e4) {
            throw new ObjectLookupException(LookupUtil.class, bean, name, e4);
        }
        catch (NestedNullException nne) {
            return null;
        }
        catch (IllegalArgumentException e5) {
            log.debug("Caught IllegalArgumentException from beanutils while looking up " + name + " in bean " + bean, e5);
            return null;
        }
    }

    public static Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (log.isDebugEnabled()) {
            log.debug("getProperty [" + name + "] on bean " + bean);
        }
        Validate.notNull(bean, "No bean specified");
        Validate.notNull(name, "No name specified");
        Object evalBean = bean;
        String evalName = name;
        if (evalBean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (evalName == null) {
            throw new IllegalArgumentException("No name specified");
        }
        int indexOfINDEXEDDELIM = -1;
        int indexOfMAPPEDDELIM = -1;
        int indexOfMAPPEDDELIM2 = -1;
        int indexOfNESTEDDELIM = -1;
        while (true) {
            indexOfNESTEDDELIM = evalName.indexOf(46);
            indexOfMAPPEDDELIM = evalName.indexOf(40);
            indexOfMAPPEDDELIM2 = evalName.indexOf(41);
            indexOfNESTEDDELIM = indexOfMAPPEDDELIM2 >= 0 && indexOfMAPPEDDELIM >= 0 && (indexOfNESTEDDELIM < 0 || indexOfNESTEDDELIM > indexOfMAPPEDDELIM) ? evalName.indexOf(46, indexOfMAPPEDDELIM2) : evalName.indexOf(46);
            if (indexOfNESTEDDELIM < 0) break;
            String next = evalName.substring(0, indexOfNESTEDDELIM);
            indexOfINDEXEDDELIM = next.indexOf(91);
            indexOfMAPPEDDELIM = next.indexOf(40);
            if ((evalBean = evalBean instanceof Map ? ((Map)evalBean).get(next) : (indexOfMAPPEDDELIM >= 0 ? PropertyUtils.getMappedProperty(evalBean, next) : (indexOfINDEXEDDELIM >= 0 ? LookupUtil.getIndexedProperty(evalBean, next) : PropertyUtils.getSimpleProperty(evalBean, next)))) == null) {
                log.debug("Null property value for '" + evalName.substring(0, indexOfNESTEDDELIM) + "'");
                return null;
            }
            evalName = evalName.substring(indexOfNESTEDDELIM + 1);
        }
        indexOfINDEXEDDELIM = evalName.indexOf(91);
        indexOfMAPPEDDELIM = evalName.indexOf(40);
        if (evalBean == null) {
            log.debug("Null property value for '" + evalName.substring(0, indexOfNESTEDDELIM) + "'");
            return null;
        }
        evalBean = evalBean instanceof Map ? ((Map)evalBean).get(evalName) : (indexOfMAPPEDDELIM >= 0 ? PropertyUtils.getMappedProperty(evalBean, evalName) : (indexOfINDEXEDDELIM >= 0 ? LookupUtil.getIndexedProperty(evalBean, evalName) : PropertyUtils.getSimpleProperty(evalBean, evalName)));
        return evalBean;
    }

    public static Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Validate.notNull(bean, "No bean specified");
        Validate.notNull(name, "No name specified");
        String evalName = name;
        int delim = evalName.indexOf(91);
        int delim2 = evalName.indexOf(93);
        if (delim < 0 || delim2 <= delim) {
            throw new IllegalArgumentException("Invalid indexed property '" + evalName + "'");
        }
        int index = -1;
        try {
            String subscript = evalName.substring(delim + 1, delim2);
            index = Integer.parseInt(subscript);
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("Invalid indexed property '" + evalName + "'");
        }
        evalName = evalName.substring(0, delim);
        if (log.isDebugEnabled()) {
            log.debug("getIndexedProperty property name={" + evalName + "} with index " + index);
        }
        if (StringUtils.isEmpty(evalName)) {
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
            if (bean.getClass().isArray()) {
                return ((Object[])bean)[index];
            }
        }
        return PropertyUtils.getIndexedProperty(bean, evalName, index);
    }
}

