/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import org.displaytag.util.HtmlAttributeMap;

public final class HtmlTagUtil {
    private HtmlTagUtil() {
    }

    public static String createOpenTagString(String tagName, HtmlAttributeMap attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<").append(tagName);
        if (attributes != null) {
            buffer.append(attributes.toString());
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static String stripHTMLTags(String str) {
        int len = str.length();
        char[] value = str.toCharArray();
        StringBuffer dest = new StringBuffer(len + 16);
        boolean intag = false;
        block4: for (int j2 = 0; j2 < len; ++j2) {
            char c2 = value[j2];
            if (intag) {
                if (c2 != '>') continue;
                intag = false;
                continue;
            }
            switch (c2) {
                case '\"': {
                    dest.append("&quot;");
                    continue block4;
                }
                case '<': {
                    intag = true;
                    continue block4;
                }
                default: {
                    dest.append(c2);
                }
            }
        }
        return dest.toString();
    }

    public static String abbreviateHtmlString(String str, int maxLength, boolean byNumberOfWords) {
        int i2;
        if (str == null || str.length() <= maxLength) {
            return str;
        }
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        boolean inTag = false;
        boolean inTagName = false;
        boolean endingTag = false;
        int count = 0;
        boolean chopped = false;
        int entityChars = 0;
        StringBuffer currentTag = new StringBuffer(5);
        ArrayList<String> openTags = new ArrayList<String>(5);
        for (i2 = 0; i2 < sz; ++i2) {
            if (count >= maxLength) {
                chopped = true;
                break;
            }
            char c2 = str.charAt(i2);
            if (c2 == '<') {
                inTag = true;
                inTagName = true;
            } else if (inTag) {
                if (inTagName && c2 == '/') {
                    if (currentTag.length() == 0) {
                        endingTag = true;
                    } else {
                        inTagName = false;
                    }
                    currentTag = new StringBuffer(5);
                } else if (inTagName && (c2 == ' ' || c2 == '>')) {
                    inTagName = false;
                    if (!endingTag) {
                        openTags.add(currentTag.toString());
                    } else {
                        openTags.remove(currentTag.toString());
                    }
                    currentTag = new StringBuffer(5);
                    if (c2 == '>') {
                        inTag = false;
                    }
                } else if (c2 == '>') {
                    inTag = false;
                } else if (inTagName) {
                    currentTag.append(c2);
                }
            } else if (byNumberOfWords) {
                if (Character.isWhitespace(c2)) {
                    ++count;
                }
            } else if (c2 == '&') {
                entityChars = 1;
            } else if (entityChars == 0) {
                ++count;
            } else {
                if (entityChars > 0 && c2 == ';') {
                    entityChars = 0;
                    ++count;
                } else {
                    ++entityChars;
                }
                if (entityChars > 5) {
                    count += entityChars;
                    entityChars = 0;
                }
            }
            if (!inTag && byNumberOfWords && count >= maxLength) continue;
            buffer.append(c2);
        }
        if (chopped) {
            buffer.append("...");
        }
        if (openTags.size() > 0) {
            String remainingToken = str.substring(i2);
            for (int j2 = openTags.size() - 1; j2 >= 0; --j2) {
                String closingTag = "</" + openTags.get(j2) + ">";
                if (remainingToken.indexOf(closingTag) <= -1) continue;
                buffer.append(closingTag);
            }
        }
        return buffer.toString();
    }
}

