/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.displaytag.exception.TagStructureException;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.tags.TableTag;
import org.displaytag.util.MediaUtil;

public class TableFooterTag
extends BodyTagSupport
implements MediaUtil.SupportsMedia {
    private static final long serialVersionUID = 899149338534L;
    private List supportedMedia;
    private boolean showAsLastRow;

    public int doEndTag() throws JspException {
        TableTag tableTag = (TableTag)TableFooterTag.findAncestorWithClass(this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "footer", "table");
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (currentMediaType != null && !MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        if (tableTag.isLastIteration() && this.getBodyContent() != null) {
            tableTag.setFooter(this.getBodyContent().getString());
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = (TableTag)TableFooterTag.findAncestorWithClass(this, TableTag.class);
        if (tableTag == null) {
            throw new TagStructureException(this.getClass(), "footer", "table");
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)this.pageContext.findAttribute("mediaType");
        if (!MediaUtil.availableForMedia(this, currentMediaType)) {
            return 0;
        }
        if (tableTag.isLastIteration()) {
            if (tableTag.getVarTotals() != null) {
                Map totals = tableTag.getTotals();
                this.pageContext.setAttribute(tableTag.getVarTotals(), totals);
            }
            return 2;
        }
        return 0;
    }

    public void setSupportedMedia(List media) {
        this.supportedMedia = media;
    }

    public List getSupportedMedia() {
        return this.supportedMedia;
    }

    public void setMedia(String media) {
        MediaUtil.setMedia(this, media);
    }

    public void release() {
        this.supportedMedia = null;
        this.showAsLastRow = false;
        super.release();
    }

    public void setShowAsLastRow(boolean showAsLastRow) {
        this.showAsLastRow = showAsLastRow;
    }
}

