/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.render;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import java.awt.Color;
import java.util.Iterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Column;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;
import org.displaytag.render.TableWriterAdapter;

public class ItextTableWriter
extends TableWriterAdapter {
    private Table table;
    private Document document;
    private Font defaultFont;

    public ItextTableWriter(Table table, Document document) {
        this.table = table;
        this.document = document;
    }

    protected void writeTableOpener(TableModel model) {
        this.table.setDefaultVerticalAlignment(4);
        this.table.setCellsFitPage(true);
        this.table.setWidth(100.0f);
        this.table.setPadding(2.0f);
        this.table.setSpacing(0.0f);
        this.table.setBorder(0);
        this.defaultFont = this.getTableFont();
    }

    protected Font getTableFont() {
        return FontFactory.getFont("Helvetica", 10.0f, 0, new Color(0, 0, 0));
    }

    protected void writeCaption(TableModel model) throws Exception {
        this.decorateCaption(model);
    }

    private void decorateCaption(TableModel model) throws DocumentException {
        Paragraph caption = new Paragraph(new Chunk(model.getCaption(), this.getCaptionFont()));
        caption.setAlignment(this.getCaptionHorizontalAlignment());
        this.document.add(caption);
    }

    protected Font getCaptionFont() {
        return FontFactory.getFont("Helvetica", 17.0f, 1, new Color(0, 0, 0));
    }

    protected int getCaptionHorizontalAlignment() {
        return 1;
    }

    protected void writeTableHeader(TableModel model) throws BadElementException {
        Iterator iterator = model.getHeaderCellList().iterator();
        float[] widths = new float[model.getNumberOfColumns()];
        int i2 = 0;
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            widths[i2] = this.getCellWidth(headerCell);
            String columnHeader = headerCell.getTitle();
            if (columnHeader == null) {
                columnHeader = StringUtils.capitalize(headerCell.getBeanPropertyName());
            }
            Cell hdrCell = this.getHeaderCell(columnHeader);
            this.table.addCell(hdrCell);
            ++i2;
        }
        this.table.setWidths(widths);
        this.table.endHeaders();
    }

    private float getCellWidth(HeaderCell headerCell) {
        int maxWidth = headerCell.getMaxLength();
        return maxWidth > 0 ? (float)maxWidth : (float)headerCell.getTitle().length();
    }

    protected void writePostBodyFooter(TableModel model) throws DocumentException {
        Chunk cellContent = new Chunk(model.getFooter(), this.getFooterFont());
        this.setFooterFontStyle(cellContent);
        Cell cell = new Cell(cellContent);
        cell.setLeading(8.0f);
        cell.setBackgroundColor(this.getFooterBackgroundColor());
        cell.setHorizontalAlignment(this.getFooterHorizontalAlignment());
        cell.setColspan(model.getNumberOfColumns());
        this.table.addCell(cell);
    }

    protected Color getFooterBackgroundColor() {
        return new Color(206, 207, 206);
    }

    protected int getFooterHorizontalAlignment() {
        return 0;
    }

    protected void setFooterFontStyle(Chunk cellContent) {
        this.setBoldStyle(cellContent, this.getFooterFontColor());
    }

    protected Color getFooterFontColor() {
        return new Color(0, 0, 0);
    }

    protected Font getFooterFont() {
        return FontFactory.getFont("Helvetica", 10.0f);
    }

    protected void writeDecoratedRowStart(TableModel model) {
        TableDecorator decorator = model.getTableDecorator();
        if (decorator instanceof ItextDecorator) {
            ItextDecorator idecorator = (ItextDecorator)((Object)decorator);
            idecorator.setTable(this.table);
            idecorator.setFont(this.defaultFont);
        }
        decorator.startRow();
    }

    protected void writeDecoratedRowFinish(TableModel model) throws Exception {
        model.getTableDecorator().finishRow();
    }

    protected void writeColumnOpener(Column column) throws ObjectLookupException, DecoratorException {
        column.initialize();
    }

    protected void writeColumnValue(Object value, Column column) throws BadElementException {
        this.table.addCell(this.getCell(value));
    }

    protected void writeDecoratedTableFinish(TableModel model) {
        model.getTableDecorator().finish();
    }

    private Cell getCell(Object value) throws BadElementException {
        Cell cell = new Cell(new Chunk(StringUtils.trimToEmpty(ObjectUtils.toString(value)), this.defaultFont));
        cell.setVerticalAlignment(4);
        cell.setLeading(8.0f);
        return cell;
    }

    private Cell getHeaderCell(String value) throws BadElementException {
        Chunk cellContent = new Chunk(value, this.getHeaderFont());
        this.setHeaderFontStyle(cellContent);
        Cell cell = new Cell(cellContent);
        cell.setLeading(8.0f);
        cell.setHeader(true);
        cell.setHorizontalAlignment(this.getHeaderHorizontalAlignment());
        cell.setBackgroundColor(this.getHeaderBackgroundColor());
        return cell;
    }

    protected Font getHeaderFont() {
        return this.defaultFont;
    }

    protected Color getHeaderBackgroundColor() {
        return new Color(238, 238, 238);
    }

    protected void setHeaderFontStyle(Chunk cellContent) {
        this.setBoldStyle(cellContent, this.getHeaderFontColor());
    }

    protected Color getHeaderFontColor() {
        return new Color(0, 0, 0);
    }

    protected int getHeaderHorizontalAlignment() {
        return 1;
    }

    private void setBoldStyle(Chunk chunk, Color color) {
        Font font = chunk.font();
        chunk.setFont(FontFactory.getFont(font.getFamilyname(), font.size(), 1, color));
    }

    public static interface ItextDecorator {
        public void setTable(Table var1);

        public void setFont(Font var1);
    }
}

