/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.pagination.NumberedPage;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.Href;

public class Pagination {
    private static Log log = LogFactory.getLog(Pagination.class);
    private Href href;
    private String pageParam;
    private Integer firstPage;
    private Integer lastPage;
    private Integer previousPage;
    private Integer nextPage;
    private Integer currentPage;
    private List pages = new ArrayList();
    private TableProperties properties;

    public Pagination(Href baseHref, String pageParameter, TableProperties properties) {
        this.href = baseHref;
        this.pageParam = pageParameter;
        this.properties = properties;
    }

    public void addPage(int number, boolean isSelected) {
        if (log.isDebugEnabled()) {
            log.debug("adding page " + number);
        }
        this.pages.add(new NumberedPage(number, isSelected));
    }

    public boolean isFirst() {
        return this.firstPage == null;
    }

    public boolean isLast() {
        return this.lastPage == null;
    }

    public boolean isOnePage() {
        return this.pages == null || this.pages.size() <= 1;
    }

    public Integer getFirst() {
        return this.firstPage;
    }

    public void setFirst(Integer first) {
        this.firstPage = first;
    }

    public Integer getLast() {
        return this.lastPage;
    }

    public void setLast(Integer last) {
        this.lastPage = last;
    }

    public Integer getPrevious() {
        return this.previousPage;
    }

    public void setPrevious(Integer previous) {
        this.previousPage = previous;
    }

    public Integer getNext() {
        return this.nextPage;
    }

    public void setNext(Integer next) {
        this.nextPage = next;
    }

    public void setCurrent(Integer current) {
        this.currentPage = current;
    }

    public String getFormattedBanner(String numberedPageFormat, String numberedPageSelectedFormat, String numberedPageSeparator, String fullBanner) {
        StringBuffer buffer = new StringBuffer(100);
        Iterator pageIterator = this.pages.iterator();
        while (pageIterator.hasNext()) {
            NumberedPage page = (NumberedPage)pageIterator.next();
            Integer pageNumber = new Integer(page.getNumber());
            String urlString = ((Object)((Href)this.href.clone()).addParameter(this.pageParam, pageNumber)).toString();
            Object[] pageObjects = new Object[]{pageNumber, urlString};
            if (page.getSelected()) {
                buffer.append(new MessageFormat(numberedPageSelectedFormat, this.properties.getLocale()).format(pageObjects));
            } else {
                buffer.append(new MessageFormat(numberedPageFormat, this.properties.getLocale()).format(pageObjects));
            }
            if (!pageIterator.hasNext()) continue;
            buffer.append(numberedPageSeparator);
        }
        String numberedPageString = buffer.toString();
        Object[] pageObjects = new Object[]{numberedPageString, ((Href)this.href.clone()).addParameter(this.pageParam, this.getFirst()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getPrevious()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getNext()), ((Href)this.href.clone()).addParameter(this.pageParam, this.getLast()), this.currentPage, this.isLast() ? this.currentPage : this.lastPage};
        return MessageFormat.format(fullBanner, pageObjects);
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("firstPage", this.firstPage).append("lastPage", this.lastPage).append("currentPage", this.currentPage).append("nextPage", this.nextPage).append("previousPage", this.previousPage).append("pages", this.pages).append("href", this.href).append("pageParam", this.pageParam).toString();
    }
}

