/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.exception.RuntimeLookupException;
import org.displaytag.model.Row;
import org.displaytag.util.LookupUtil;

public class RowSorter
implements Comparator {
    private String property;
    private TableDecorator decorator;
    private boolean ascending;
    private int columnIndex;
    private Comparator comparator;

    public RowSorter(int sortedColumnIndex, String beanProperty, TableDecorator tableDecorator, boolean ascendingOrder, Comparator compar) {
        this.columnIndex = sortedColumnIndex;
        this.property = beanProperty;
        this.decorator = tableDecorator;
        this.ascending = ascendingOrder;
        this.comparator = compar;
        if (compar == null) {
            throw new IllegalArgumentException("A null comparator has been passed to RowSorter. A comparator instance is required");
        }
    }

    public final int compare(Object object1, Object object2) {
        Object obj1 = null;
        Object obj2 = null;
        if (this.property == null) {
            if (object1 instanceof Row) {
                obj1 = ((Row)object1).getCellList().get(this.columnIndex);
            }
            if (object2 instanceof Row) {
                obj2 = ((Row)object2).getCellList().get(this.columnIndex);
            }
            return this.checkNullsAndCompare(obj1, obj2);
        }
        if (object1 instanceof Row) {
            obj1 = ((Row)object1).getObject();
        }
        if (object2 instanceof Row) {
            obj2 = ((Row)object2).getObject();
        }
        try {
            Object result2;
            Object result1;
            if (this.decorator != null && this.decorator.hasGetterFor(this.property)) {
                this.decorator.initRow(obj1, 0, 0);
                result1 = LookupUtil.getBeanProperty(this.decorator, this.property);
                this.decorator.initRow(obj2, 0, 0);
                result2 = LookupUtil.getBeanProperty(this.decorator, this.property);
            } else {
                result1 = LookupUtil.getBeanProperty(obj1, this.property);
                result2 = LookupUtil.getBeanProperty(obj2, this.property);
            }
            return this.checkNullsAndCompare(result1, result2);
        }
        catch (ObjectLookupException e2) {
            throw new RuntimeLookupException(this.getClass(), this.property, e2);
        }
    }

    private int checkNullsAndCompare(Object object1, Object object2) {
        int returnValue = object1 == null && object2 != null ? -1 : (object1 != null && object2 == null ? 1 : (object1 == null && object2 == null ? 0 : this.comparator.compare(object1, object2)));
        int ascendingInt = this.ascending ? 1 : -1;
        return ascendingInt * returnValue;
    }

    public final boolean equals(Object object) {
        if (object instanceof RowSorter) {
            return new EqualsBuilder().append(this.property, ((RowSorter)object).property).append(this.columnIndex, ((RowSorter)object).columnIndex).isEquals();
        }
        return false;
    }

    public final int hashCode() {
        return new HashCodeBuilder(31, 33).append(this.property).append(this.columnIndex).toHashCode();
    }
}

