/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.util.Anchor;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.HtmlTagUtil;
import org.displaytag.util.LookupUtil;

public class Column {
    private Row row;
    private HeaderCell header;
    private HtmlAttributeMap htmlAttributes;
    private String stringValue;
    private Cell cell;

    public Column(HeaderCell headerCell, Cell currentCell, Row parentRow) {
        this.header = headerCell;
        this.row = parentRow;
        this.cell = currentCell;
        this.htmlAttributes = headerCell.getHtmlAttributes();
    }

    public HeaderCell getHeaderCell() {
        return this.header;
    }

    public Object getValue(boolean decorated) throws ObjectLookupException, DecoratorException {
        Object object = null;
        if (this.cell.getStaticValue() != null) {
            object = this.cell.getStaticValue();
        } else if (this.header.getBeanPropertyName() != null) {
            object = decorated && this.row.getParentTable().getTableDecorator() != null && this.row.getParentTable().getTableDecorator().hasGetterFor(this.header.getBeanPropertyName()) ? LookupUtil.getBeanProperty(this.row.getParentTable().getTableDecorator(), this.header.getBeanPropertyName()) : LookupUtil.getBeanProperty(this.row.getObject(), this.header.getBeanPropertyName());
        }
        DisplaytagColumnDecorator[] decorators = this.header.getColumnDecorators();
        if (decorated) {
            for (int j2 = 0; j2 < decorators.length; ++j2) {
                object = decorators[j2].decorate(object, this.row.getParentTable().getPageContext(), this.row.getParentTable().getMedia());
            }
        }
        if ((object == null || "null".equals(object)) && !this.header.getShowNulls()) {
            object = "";
        }
        return object;
    }

    public String getOpenTag() {
        HtmlAttributeMap rowAttributes = this.cell.getPerRowAttributes();
        HtmlAttributeMap atts = this.htmlAttributes;
        if (rowAttributes != null) {
            atts = (HtmlAttributeMap)atts.clone();
            atts.putAll(rowAttributes);
        }
        return HtmlTagUtil.createOpenTagString("td", atts);
    }

    public void initialize() throws DecoratorException, ObjectLookupException {
        if (this.stringValue == null) {
            this.stringValue = this.createChoppedAndLinkedValue();
        }
    }

    public String getCloseTag() {
        this.stringValue = null;
        return this.header.getCloseTag();
    }

    public String createChoppedAndLinkedValue() throws ObjectLookupException, DecoratorException {
        String choppedValue;
        String fullValue = ObjectUtils.toString(this.getValue(true));
        if (!ObjectUtils.equals(fullValue, choppedValue = this.header.getMaxLength() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxLength(), false) : (this.header.getMaxWords() > 0 ? HtmlTagUtil.abbreviateHtmlString(fullValue, this.header.getMaxWords(), true) : fullValue))) {
            this.htmlAttributes = (HtmlAttributeMap)this.htmlAttributes.clone();
            this.htmlAttributes.put("title", HtmlTagUtil.stripHTMLTags(fullValue));
        }
        if (this.header.getHref() != null) {
            Href colHref = this.getColumnHref(fullValue);
            Anchor anchor = new Anchor(colHref, choppedValue);
            choppedValue = anchor.toString();
        }
        return choppedValue;
    }

    private Href getColumnHref(String columnContent) throws ObjectLookupException {
        Object paramValue;
        Href colHref = (Href)this.header.getHref().clone();
        if (this.header.getParamName() != null && (paramValue = this.header.getParamProperty() != null ? LookupUtil.getBeanProperty(this.row.getObject(), this.header.getParamProperty()) : columnContent) != null) {
            try {
                colHref.addParameter(this.header.getParamName(), URLEncoder.encode(paramValue.toString(), StringUtils.defaultString(this.row.getParentTable().getEncoding(), "UTF8")));
            }
            catch (UnsupportedEncodingException e2) {
                throw new UnhandledException(e2);
            }
        }
        return colHref;
    }

    public String getChoppedAndLinkedValue() {
        return this.stringValue;
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("cell", this.cell).append("header", this.header).append("htmlAttributes", this.htmlAttributes).append("stringValue", this.stringValue).toString();
    }
}

