/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.properties.MediaTypeEnum;

public class MessageFormatColumnDecorator
implements DisplaytagColumnDecorator {
    private static Log log = LogFactory.getLog(MessageFormatColumnDecorator.class);
    private MessageFormat format;

    public MessageFormatColumnDecorator(String pattern, Locale locale) {
        this.format = new MessageFormat(pattern, locale);
    }

    public Object decorate(Object columnValue, PageContext pageContext, MediaTypeEnum media) {
        try {
            return this.format.format(new Object[]{columnValue});
        }
        catch (IllegalArgumentException e2) {
            log.error(Messages.getString("MessageFormatColumnDecorator.invalidArgument", new Object[]{this.format.toPattern(), columnValue != null ? columnValue.getClass().getName() : "null"}));
            return columnValue;
        }
    }
}

