/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.tools;

import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.Traceable;

public abstract class AbstractTrace
implements Trace {
    protected Class tracedClass;
    private static SimpleDateFormat timeFormat;

    protected AbstractTrace(Class clazz) {
        this.tracedClass = clazz;
    }

    public abstract void enter(String var1, Object var2, Object[] var3);

    public abstract void enter(String var1, Object var2);

    public abstract void exit(String var1, Object var2);

    public abstract void exit(String var1, Throwable var2);

    public void enter(String methodName) {
        this.enter(methodName, null, null);
    }

    public void enter(String methodName, Object thiz, Object arg) {
        this.enter(methodName, thiz, new Object[]{arg});
    }

    public void enter(String methodName, Object thiz, boolean z) {
        this.enter(methodName, thiz, new Boolean(z));
    }

    public void exit(String methodName, boolean b2) {
        this.exit(methodName, new Boolean(b2));
    }

    public void exit(String methodName, int i2) {
        this.exit(methodName, new Integer(i2));
    }

    public void event(String methodName, Object thiz, Object arg) {
        this.event(methodName, thiz, new Object[]{arg});
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void fatal(String message) {
        this.fatal(message, null);
    }

    protected String formatMessage(String kind, String className, String methodName, Object thiz, Object[] args) {
        StringBuffer message = new StringBuffer();
        Date now = new Date();
        message.append(AbstractTrace.formatDate(now)).append(" ");
        message.append(Thread.currentThread().getName()).append(" ");
        message.append(kind).append(" ");
        message.append(className);
        message.append(".").append(methodName);
        if (thiz != null) {
            message.append(" ").append(this.formatObj(thiz));
        }
        if (args != null) {
            message.append(" ").append(this.formatArgs(args));
        }
        return message.toString();
    }

    protected String formatMessage(String kind, String text, Throwable th) {
        StringBuffer message = new StringBuffer();
        Date now = new Date();
        message.append(AbstractTrace.formatDate(now)).append(" ");
        message.append(Thread.currentThread().getName()).append(" ");
        message.append(kind).append(" ");
        message.append(text);
        if (th != null) {
            message.append(" ").append(this.formatObj(th));
        }
        return message.toString();
    }

    private static String formatDate(Date date) {
        if (timeFormat == null) {
            timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        }
        return timeFormat.format(date);
    }

    protected Object formatObj(Object obj) {
        if (obj == null || obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Exception || obj instanceof Character || obj instanceof Class || obj instanceof File || obj instanceof StringBuffer || obj instanceof URL || obj instanceof IMessage.Kind) {
            return obj;
        }
        if (obj.getClass().isArray()) {
            return this.formatArray(obj);
        }
        if (obj instanceof Collection) {
            return this.formatCollection((Collection)obj);
        }
        try {
            if (obj instanceof Traceable) {
                Traceable t = (Traceable)obj;
                return t.toTraceString();
            }
            return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
        }
        catch (Exception ex) {
            return obj.getClass().getName() + "@FFFFFFFF";
        }
    }

    protected String formatArray(Object obj) {
        return obj.getClass().getComponentType().getName() + "[" + Array.getLength(obj) + "]";
    }

    protected String formatCollection(Collection c2) {
        return c2.getClass().getName() + "(" + c2.size() + ")";
    }

    protected String formatArgs(Object[] args) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < args.length; ++i2) {
            sb.append(this.formatObj(args[i2]));
            if (i2 >= args.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected Object[] formatObjects(Object[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            args[i2] = this.formatObj(args[i2]);
        }
        return args;
    }
}

