/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;

public class ScopeWithTypeVariables
implements IScope {
    private IScope delegateScope;
    private String[] typeVariableNames;
    private UnresolvedTypeVariableReferenceType[] typeVarTypeXs;

    public ScopeWithTypeVariables(String[] typeVarNames, IScope delegate) {
        this.delegateScope = delegate;
        this.typeVariableNames = typeVarNames;
        this.typeVarTypeXs = new UnresolvedTypeVariableReferenceType[typeVarNames.length];
    }

    public UnresolvedType lookupType(String name, IHasPosition location) {
        for (int i2 = 0; i2 < this.typeVariableNames.length; ++i2) {
            if (!this.typeVariableNames[i2].equals(name)) continue;
            if (this.typeVarTypeXs[i2] == null) {
                this.typeVarTypeXs[i2] = new UnresolvedTypeVariableReferenceType(new TypeVariable(name));
            }
            return this.typeVarTypeXs[i2];
        }
        return this.delegateScope.lookupType(name, location);
    }

    public World getWorld() {
        return this.delegateScope.getWorld();
    }

    public ResolvedType getEnclosingType() {
        return this.delegateScope.getEnclosingType();
    }

    public IMessageHandler getMessageHandler() {
        return this.delegateScope.getMessageHandler();
    }

    public FormalBinding lookupFormal(String name) {
        return this.delegateScope.lookupFormal(name);
    }

    public FormalBinding getFormal(int i2) {
        return this.delegateScope.getFormal(i2);
    }

    public int getFormalCount() {
        return this.delegateScope.getFormalCount();
    }

    public String[] getImportedPrefixes() {
        return this.delegateScope.getImportedPrefixes();
    }

    public String[] getImportedNames() {
        return this.delegateScope.getImportedNames();
    }

    public void message(IMessage.Kind kind, IHasPosition location, String message) {
        this.delegateScope.message(kind, location, message);
    }

    public void message(IMessage.Kind kind, IHasPosition location1, IHasPosition location2, String message) {
        this.delegateScope.message(kind, location1, location2, message);
    }

    public void message(IMessage aMessage) {
        this.delegateScope.message(aMessage);
    }
}

