/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingPattern;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;

public class BindingAnnotationFieldTypePattern
extends ExactAnnotationTypePattern
implements BindingPattern {
    protected int formalIndex;
    UnresolvedType formalType;

    public BindingAnnotationFieldTypePattern(UnresolvedType formalType, int formalIndex, UnresolvedType theAnnotationType) {
        super(theAnnotationType, null);
        this.formalIndex = formalIndex;
        this.formalType = formalType;
    }

    public void resolveBinding(World world) {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.formalType = world.resolve(this.formalType);
        this.annotationType = world.resolve(this.annotationType);
        ResolvedType annoType = (ResolvedType)this.annotationType;
        if (!annoType.isAnnotation()) {
            IMessage m2 = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", annoType.getName()), this.getSourceLocation());
            world.getMessageHandler().handleMessage(m2);
            this.resolved = false;
        }
    }

    public AnnotationTypePattern parameterizeWith(Map typeVariableMap, World w) {
        throw new BCException("Parameterization not implemented for annotation field binding construct (compiler limitation)");
    }

    public int getFormalIndex() {
        return this.formalIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BindingAnnotationFieldTypePattern)) {
            return false;
        }
        BindingAnnotationFieldTypePattern btp = (BindingAnnotationFieldTypePattern)obj;
        return btp.formalIndex == this.formalIndex && this.annotationType.equals(btp.annotationType) && this.formalType.equals(btp.formalType);
    }

    public int hashCode() {
        return this.annotationType.hashCode() * 37 + this.formalIndex * 37 + this.formalType.hashCode();
    }

    public AnnotationTypePattern remapAdviceFormals(IntMap bindings) {
        if (!bindings.hasKey(this.formalIndex)) {
            throw new BCException("Annotation field binding reference must be bound (compiler limitation)");
        }
        int newFormalIndex = bindings.get(this.formalIndex);
        return new BindingAnnotationFieldTypePattern(this.formalType, newFormalIndex, this.annotationType);
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeByte(10);
        this.formalType.write(s2);
        s2.writeShort((short)this.formalIndex);
        this.annotationType.write(s2);
        this.writeLocation(s2);
    }

    public static AnnotationTypePattern read(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        BindingAnnotationFieldTypePattern ret = new BindingAnnotationFieldTypePattern(UnresolvedType.read(s2), s2.readShort(), UnresolvedType.read(s2));
        ret.readLocation(context, s2);
        return ret;
    }

    public FuzzyBoolean matches(AnnotatedElement annotated, ResolvedType[] parameterAnnotations) {
        if (annotated.hasAnnotation(this.annotationType) && this.annotationType instanceof ReferenceType) {
            ReferenceType rt = (ReferenceType)this.annotationType;
            if (rt.getRetentionPolicy() != null && rt.getRetentionPolicy().equals("SOURCE")) {
                rt.getWorld().getMessageHandler().handleMessage(MessageUtil.warn(WeaverMessages.format("noMatchBecauseSourceRetention", this.annotationType, annotated), this.getSourceLocation()));
                return FuzzyBoolean.NO;
            }
            ResolvedMember[] methods = rt.getDeclaredMethods();
            boolean found = false;
            for (int i2 = 0; i2 < methods.length && !found; ++i2) {
                if (!methods[i2].getReturnType().equals(this.formalType)) continue;
                found = true;
            }
            return found ? FuzzyBoolean.YES : FuzzyBoolean.NO;
        }
        return FuzzyBoolean.NO;
    }

    public UnresolvedType getFormalType() {
        return this.formalType;
    }
}

