/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariableDeclaringElement;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;

public class TypeVariable {
    public static final TypeVariable[] NONE = new TypeVariable[0];
    private boolean isResolved = false;
    private boolean beingResolved = false;
    private String name;
    private int rank;
    private int declaringElementKind = -1;
    public static final int UNKNOWN = -1;
    public static final int METHOD = 1;
    public static final int TYPE = 2;
    private TypeVariableDeclaringElement declaringElement;
    private UnresolvedType upperBound = UnresolvedType.OBJECT;
    private UnresolvedType[] additionalInterfaceBounds = new UnresolvedType[0];
    private UnresolvedType lowerBound = null;

    public TypeVariable(String aName) {
        this.name = aName;
    }

    public TypeVariable(String aName, UnresolvedType anUpperBound) {
        this(aName);
        this.upperBound = anUpperBound;
    }

    public TypeVariable(String aName, UnresolvedType anUpperBound, UnresolvedType[] someAdditionalInterfaceBounds) {
        this(aName, anUpperBound);
        this.additionalInterfaceBounds = someAdditionalInterfaceBounds;
    }

    public TypeVariable(String aName, UnresolvedType anUpperBound, UnresolvedType[] someAdditionalInterfaceBounds, UnresolvedType aLowerBound) {
        this(aName, anUpperBound, someAdditionalInterfaceBounds);
        this.lowerBound = aLowerBound;
    }

    public UnresolvedType getFirstBound() {
        if (this.upperBound.equals(UnresolvedType.OBJECT) && this.additionalInterfaceBounds != null && this.additionalInterfaceBounds.length != 0) {
            return this.additionalInterfaceBounds[0];
        }
        return this.upperBound;
    }

    public UnresolvedType getUpperBound() {
        return this.upperBound;
    }

    public UnresolvedType[] getAdditionalInterfaceBounds() {
        return this.additionalInterfaceBounds;
    }

    public UnresolvedType getLowerBound() {
        return this.lowerBound;
    }

    public String getName() {
        return this.name;
    }

    public TypeVariable resolve(World inSomeWorld) {
        if (this.beingResolved) {
            return this;
        }
        this.beingResolved = true;
        if (this.isResolved) {
            return this;
        }
        TypeVariable resolvedTVar = null;
        if (this.declaringElement != null) {
            TypeVariableDeclaringElement declaring;
            if (this.declaringElementKind == 2) {
                declaring = (UnresolvedType)this.declaringElement;
                ReferenceType rd = (ReferenceType)((UnresolvedType)declaring).resolve(inSomeWorld);
                TypeVariable[] tVars = rd.getTypeVariables();
                for (int i2 = 0; i2 < tVars.length; ++i2) {
                    if (!tVars[i2].getName().equals(this.getName())) continue;
                    resolvedTVar = tVars[i2];
                    break;
                }
            } else {
                declaring = (ResolvedMember)this.declaringElement;
                TypeVariable[] tvrts = declaring.getTypeVariables();
                for (int i3 = 0; i3 < tvrts.length; ++i3) {
                    if (!tvrts[i3].getName().equals(this.getName())) continue;
                    resolvedTVar = tvrts[i3];
                }
            }
            if (resolvedTVar == null) {
                resolvedTVar = this;
            }
        } else {
            resolvedTVar = this;
        }
        this.upperBound = resolvedTVar.upperBound;
        this.lowerBound = resolvedTVar.lowerBound;
        this.additionalInterfaceBounds = resolvedTVar.additionalInterfaceBounds;
        this.upperBound = this.upperBound.resolve(inSomeWorld);
        if (this.lowerBound != null) {
            this.lowerBound = this.lowerBound.resolve(inSomeWorld);
        }
        if (this.additionalInterfaceBounds != null) {
            for (int i4 = 0; i4 < this.additionalInterfaceBounds.length; ++i4) {
                this.additionalInterfaceBounds[i4] = this.additionalInterfaceBounds[i4].resolve(inSomeWorld);
            }
        }
        this.isResolved = true;
        this.beingResolved = false;
        return this;
    }

    public boolean canBeBoundTo(ResolvedType aCandidateType) {
        if (!this.isResolved) {
            throw new IllegalStateException("Can't answer binding questions prior to resolving");
        }
        if (aCandidateType.isGenericWildcard()) {
            return true;
        }
        if (!this.isASubtypeOf(this.upperBound, aCandidateType)) {
            return false;
        }
        for (int i2 = 0; i2 < this.additionalInterfaceBounds.length; ++i2) {
            if (this.isASubtypeOf(this.additionalInterfaceBounds[i2], aCandidateType)) continue;
            return false;
        }
        return this.lowerBound == null || this.isASubtypeOf(aCandidateType, this.lowerBound);
    }

    private boolean isASubtypeOf(UnresolvedType candidateSuperType, UnresolvedType candidateSubType) {
        ResolvedType superType = (ResolvedType)candidateSuperType;
        ResolvedType subType = (ResolvedType)candidateSubType;
        return superType.isAssignableFrom(subType);
    }

    public void setUpperBound(UnresolvedType aTypeX) {
        this.upperBound = aTypeX;
    }

    public void setLowerBound(UnresolvedType aTypeX) {
        this.lowerBound = aTypeX;
    }

    public void setAdditionalInterfaceBounds(UnresolvedType[] someTypeXs) {
        this.additionalInterfaceBounds = someTypeXs;
    }

    public String toDebugString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.name);
        if (!this.getFirstBound().getName().equals("java.lang.Object")) {
            ret.append(" extends ");
            ret.append(this.getFirstBound().getName());
            if (this.additionalInterfaceBounds != null) {
                for (int i2 = 0; i2 < this.additionalInterfaceBounds.length; ++i2) {
                    if (this.getFirstBound().equals(this.additionalInterfaceBounds[i2])) continue;
                    ret.append(" & ");
                    ret.append(this.additionalInterfaceBounds[i2].getName());
                }
            }
        }
        if (this.lowerBound != null) {
            ret.append(" super ");
            ret.append(this.lowerBound.getName());
        }
        return ret.toString();
    }

    public String toString() {
        return "TypeVar " + this.getDisplayName();
    }

    public String getSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(":");
        sb.append(this.upperBound.getSignature());
        if (this.additionalInterfaceBounds != null && this.additionalInterfaceBounds.length != 0) {
            sb.append(":");
            for (int i2 = 0; i2 < this.additionalInterfaceBounds.length; ++i2) {
                UnresolvedType iBound = this.additionalInterfaceBounds[i2];
                sb.append(iBound.getSignature());
            }
        }
        return sb.toString();
    }

    public String getSignatureForAttribute() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(":");
        sb.append(((ResolvedType)this.upperBound).getSignatureForAttribute());
        if (this.additionalInterfaceBounds != null && this.additionalInterfaceBounds.length != 0) {
            sb.append(":");
            for (int i2 = 0; i2 < this.additionalInterfaceBounds.length; ++i2) {
                ResolvedType iBound = (ResolvedType)this.additionalInterfaceBounds[i2];
                sb.append(iBound.getSignatureForAttribute());
            }
        }
        return sb.toString();
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getRank() {
        return this.rank;
    }

    public void setDeclaringElement(TypeVariableDeclaringElement element) {
        this.declaringElement = element;
        this.declaringElementKind = element instanceof UnresolvedType ? 2 : 1;
    }

    public TypeVariableDeclaringElement getDeclaringElement() {
        return this.declaringElement;
    }

    public void setDeclaringElementKind(int kind) {
        this.declaringElementKind = kind;
    }

    public int getDeclaringElementKind() {
        return this.declaringElementKind;
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeUTF(this.name);
        this.upperBound.write(s2);
        if (this.additionalInterfaceBounds == null || this.additionalInterfaceBounds.length == 0) {
            s2.writeInt(0);
        } else {
            s2.writeInt(this.additionalInterfaceBounds.length);
            for (int i2 = 0; i2 < this.additionalInterfaceBounds.length; ++i2) {
                UnresolvedType ibound = this.additionalInterfaceBounds[i2];
                ibound.write(s2);
            }
        }
    }

    public static TypeVariable read(VersionedDataInputStream s2) throws IOException {
        String name = s2.readUTF();
        UnresolvedType ubound = UnresolvedType.read(s2);
        int iboundcount = s2.readInt();
        UnresolvedType[] ibounds = UnresolvedType.NONE;
        if (iboundcount > 0) {
            ibounds = new UnresolvedType[iboundcount];
            for (int i2 = 0; i2 < iboundcount; ++i2) {
                ibounds[i2] = UnresolvedType.read(s2);
            }
        }
        TypeVariable newVariable = new TypeVariable(name, ubound, ibounds);
        return newVariable;
    }

    public String getGenericSignature() {
        return "T" + this.name + ";";
    }

    public String getErasureSignature() {
        return this.getFirstBound().getErasureSignature();
    }
}

